/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.FilterGroupsCopier;
import software.amazon.awssdk.services.codebuild.model.WebhookBuildType;
import software.amazon.awssdk.services.codebuild.model.WebhookFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWebhookRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, UpdateWebhookRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(UpdateWebhookRequest.getter(UpdateWebhookRequest::projectName)).setter(UpdateWebhookRequest.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<String> BRANCH_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("branchFilter").getter(UpdateWebhookRequest.getter(UpdateWebhookRequest::branchFilter)).setter(UpdateWebhookRequest.setter(Builder::branchFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchFilter").build()}).build();
    private static final SdkField<Boolean> ROTATE_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("rotateSecret").getter(UpdateWebhookRequest.getter(UpdateWebhookRequest::rotateSecret)).setter(UpdateWebhookRequest.setter(Builder::rotateSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rotateSecret").build()}).build();
    private static final SdkField<List<List<WebhookFilter>>> FILTER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filterGroups").getter(UpdateWebhookRequest.getter(UpdateWebhookRequest::filterGroups)).setter(UpdateWebhookRequest.setter(Builder::filterGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WebhookFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> BUILD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildType").getter(UpdateWebhookRequest.getter(UpdateWebhookRequest::buildTypeAsString)).setter(UpdateWebhookRequest.setter(Builder::buildType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD, BRANCH_FILTER_FIELD, ROTATE_SECRET_FIELD, FILTER_GROUPS_FIELD, BUILD_TYPE_FIELD));
    private final String projectName;
    private final String branchFilter;
    private final Boolean rotateSecret;
    private final List<List<WebhookFilter>> filterGroups;
    private final String buildType;

    private UpdateWebhookRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.branchFilter = builder.branchFilter;
        this.rotateSecret = builder.rotateSecret;
        this.filterGroups = builder.filterGroups;
        this.buildType = builder.buildType;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String branchFilter() {
        return this.branchFilter;
    }

    public final Boolean rotateSecret() {
        return this.rotateSecret;
    }

    public final boolean hasFilterGroups() {
        return this.filterGroups != null && !(this.filterGroups instanceof SdkAutoConstructList);
    }

    public final List<List<WebhookFilter>> filterGroups() {
        return this.filterGroups;
    }

    public final WebhookBuildType buildType() {
        return WebhookBuildType.fromValue(this.buildType);
    }

    public final String buildTypeAsString() {
        return this.buildType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotateSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterGroups() ? this.filterGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.buildTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebhookRequest)) {
            return false;
        }
        UpdateWebhookRequest other = (UpdateWebhookRequest)((Object)obj);
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.branchFilter(), other.branchFilter()) && Objects.equals(this.rotateSecret(), other.rotateSecret()) && this.hasFilterGroups() == other.hasFilterGroups() && Objects.equals(this.filterGroups(), other.filterGroups()) && Objects.equals(this.buildTypeAsString(), other.buildTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWebhookRequest").add("ProjectName", (Object)this.projectName()).add("BranchFilter", (Object)this.branchFilter()).add("RotateSecret", (Object)this.rotateSecret()).add("FilterGroups", this.hasFilterGroups() ? this.filterGroups() : null).add("BuildType", (Object)this.buildTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "branchFilter": {
                return Optional.ofNullable(clazz.cast(this.branchFilter()));
            }
            case "rotateSecret": {
                return Optional.ofNullable(clazz.cast(this.rotateSecret()));
            }
            case "filterGroups": {
                return Optional.ofNullable(clazz.cast(this.filterGroups()));
            }
            case "buildType": {
                return Optional.ofNullable(clazz.cast(this.buildTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWebhookRequest, T> g) {
        return obj -> g.apply((UpdateWebhookRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String projectName;
        private String branchFilter;
        private Boolean rotateSecret;
        private List<List<WebhookFilter>> filterGroups = DefaultSdkAutoConstructList.getInstance();
        private String buildType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWebhookRequest model) {
            super(model);
            this.projectName(model.projectName);
            this.branchFilter(model.branchFilter);
            this.rotateSecret(model.rotateSecret);
            this.filterGroups(model.filterGroups);
            this.buildType(model.buildType);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final String getBranchFilter() {
            return this.branchFilter;
        }

        @Override
        public final Builder branchFilter(String branchFilter) {
            this.branchFilter = branchFilter;
            return this;
        }

        public final void setBranchFilter(String branchFilter) {
            this.branchFilter = branchFilter;
        }

        public final Boolean getRotateSecret() {
            return this.rotateSecret;
        }

        @Override
        public final Builder rotateSecret(Boolean rotateSecret) {
            this.rotateSecret = rotateSecret;
            return this;
        }

        public final void setRotateSecret(Boolean rotateSecret) {
            this.rotateSecret = rotateSecret;
        }

        public final List<List<WebhookFilter.Builder>> getFilterGroups() {
            List<List<WebhookFilter.Builder>> result = FilterGroupsCopier.copyToBuilder(this.filterGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filterGroups(Collection<? extends Collection<WebhookFilter>> filterGroups) {
            this.filterGroups = FilterGroupsCopier.copy(filterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterGroups(Collection<WebhookFilter> ... filterGroups) {
            this.filterGroups((Collection<? extends Collection<WebhookFilter>>)Arrays.asList(filterGroups));
            return this;
        }

        public final void setFilterGroups(Collection<? extends Collection<WebhookFilter.BuilderImpl>> filterGroups) {
            this.filterGroups = FilterGroupsCopier.copyFromBuilder(filterGroups);
        }

        public final String getBuildType() {
            return this.buildType;
        }

        @Override
        public final Builder buildType(String buildType) {
            this.buildType = buildType;
            return this;
        }

        @Override
        public final Builder buildType(WebhookBuildType buildType) {
            this.buildType(buildType == null ? null : buildType.toString());
            return this;
        }

        public final void setBuildType(String buildType) {
            this.buildType = buildType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWebhookRequest build() {
            return new UpdateWebhookRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWebhookRequest> {
        public Builder projectName(String var1);

        public Builder branchFilter(String var1);

        public Builder rotateSecret(Boolean var1);

        public Builder filterGroups(Collection<? extends Collection<WebhookFilter>> var1);

        public Builder filterGroups(Collection<WebhookFilter> ... var1);

        public Builder buildType(String var1);

        public Builder buildType(WebhookBuildType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

