/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetReportsRequest extends CodeBuildRequest implements
        ToCopyableBuilder<BatchGetReportsRequest.Builder, BatchGetReportsRequest> {
    private static final SdkField<List<String>> REPORT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("reportArns")
            .getter(getter(BatchGetReportsRequest::reportArns))
            .setter(setter(Builder::reportArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ARNS_FIELD));

    private final List<String> reportArns;

    private BatchGetReportsRequest(BuilderImpl builder) {
        super(builder);
        this.reportArns = builder.reportArns;
    }

    /**
     * Returns true if the ReportArns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasReportArns() {
        return reportArns != null && !(reportArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of ARNs that identify the <code>Report</code> objects to return.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReportArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of ARNs that identify the <code>Report</code> objects to return.
     */
    public final List<String> reportArns() {
        return reportArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReportArns() ? reportArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetReportsRequest)) {
            return false;
        }
        BatchGetReportsRequest other = (BatchGetReportsRequest) obj;
        return hasReportArns() == other.hasReportArns() && Objects.equals(reportArns(), other.reportArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetReportsRequest").add("ReportArns", hasReportArns() ? reportArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reportArns":
            return Optional.ofNullable(clazz.cast(reportArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetReportsRequest, T> g) {
        return obj -> g.apply((BatchGetReportsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetReportsRequest> {
        /**
         * <p>
         * An array of ARNs that identify the <code>Report</code> objects to return.
         * </p>
         * 
         * @param reportArns
         *        An array of ARNs that identify the <code>Report</code> objects to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportArns(Collection<String> reportArns);

        /**
         * <p>
         * An array of ARNs that identify the <code>Report</code> objects to return.
         * </p>
         * 
         * @param reportArns
         *        An array of ARNs that identify the <code>Report</code> objects to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportArns(String... reportArns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private List<String> reportArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetReportsRequest model) {
            super(model);
            reportArns(model.reportArns);
        }

        public final Collection<String> getReportArns() {
            if (reportArns instanceof SdkAutoConstructList) {
                return null;
            }
            return reportArns;
        }

        @Override
        public final Builder reportArns(Collection<String> reportArns) {
            this.reportArns = ReportArnsCopier.copy(reportArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportArns(String... reportArns) {
            reportArns(Arrays.asList(reportArns));
            return this;
        }

        public final void setReportArns(Collection<String> reportArns) {
            this.reportArns = ReportArnsCopier.copy(reportArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetReportsRequest build() {
            return new BatchGetReportsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
