/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetBuildBatchesResponse extends CodeBuildResponse implements
        ToCopyableBuilder<BatchGetBuildBatchesResponse.Builder, BatchGetBuildBatchesResponse> {
    private static final SdkField<List<BuildBatch>> BUILD_BATCHES_FIELD = SdkField
            .<List<BuildBatch>> builder(MarshallingType.LIST)
            .memberName("buildBatches")
            .getter(getter(BatchGetBuildBatchesResponse::buildBatches))
            .setter(setter(Builder::buildBatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildBatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BuildBatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(BuildBatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BUILD_BATCHES_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("buildBatchesNotFound")
            .getter(getter(BatchGetBuildBatchesResponse::buildBatchesNotFound))
            .setter(setter(Builder::buildBatchesNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildBatchesNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILD_BATCHES_FIELD,
            BUILD_BATCHES_NOT_FOUND_FIELD));

    private final List<BuildBatch> buildBatches;

    private final List<String> buildBatchesNotFound;

    private BatchGetBuildBatchesResponse(BuilderImpl builder) {
        super(builder);
        this.buildBatches = builder.buildBatches;
        this.buildBatchesNotFound = builder.buildBatchesNotFound;
    }

    /**
     * Returns true if the BuildBatches property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasBuildBatches() {
        return buildBatches != null && !(buildBatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>BuildBatch</code> objects that represent the retrieved batch builds.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBuildBatches()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>BuildBatch</code> objects that represent the retrieved batch builds.
     */
    public final List<BuildBatch> buildBatches() {
        return buildBatches;
    }

    /**
     * Returns true if the BuildBatchesNotFound property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasBuildBatchesNotFound() {
        return buildBatchesNotFound != null && !(buildBatchesNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains the identifiers of any batch builds that are not found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBuildBatchesNotFound()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that contains the identifiers of any batch builds that are not found.
     */
    public final List<String> buildBatchesNotFound() {
        return buildBatchesNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBuildBatches() ? buildBatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBuildBatchesNotFound() ? buildBatchesNotFound() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetBuildBatchesResponse)) {
            return false;
        }
        BatchGetBuildBatchesResponse other = (BatchGetBuildBatchesResponse) obj;
        return hasBuildBatches() == other.hasBuildBatches() && Objects.equals(buildBatches(), other.buildBatches())
                && hasBuildBatchesNotFound() == other.hasBuildBatchesNotFound()
                && Objects.equals(buildBatchesNotFound(), other.buildBatchesNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetBuildBatchesResponse").add("BuildBatches", hasBuildBatches() ? buildBatches() : null)
                .add("BuildBatchesNotFound", hasBuildBatchesNotFound() ? buildBatchesNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "buildBatches":
            return Optional.ofNullable(clazz.cast(buildBatches()));
        case "buildBatchesNotFound":
            return Optional.ofNullable(clazz.cast(buildBatchesNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetBuildBatchesResponse, T> g) {
        return obj -> g.apply((BatchGetBuildBatchesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetBuildBatchesResponse> {
        /**
         * <p>
         * An array of <code>BuildBatch</code> objects that represent the retrieved batch builds.
         * </p>
         * 
         * @param buildBatches
         *        An array of <code>BuildBatch</code> objects that represent the retrieved batch builds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildBatches(Collection<BuildBatch> buildBatches);

        /**
         * <p>
         * An array of <code>BuildBatch</code> objects that represent the retrieved batch builds.
         * </p>
         * 
         * @param buildBatches
         *        An array of <code>BuildBatch</code> objects that represent the retrieved batch builds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildBatches(BuildBatch... buildBatches);

        /**
         * <p>
         * An array of <code>BuildBatch</code> objects that represent the retrieved batch builds.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BuildBatch>.Builder} avoiding the need to
         * create one manually via {@link List<BuildBatch>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BuildBatch>.Builder#build()} is called immediately and its
         * result is passed to {@link #buildBatches(List<BuildBatch>)}.
         * 
         * @param buildBatches
         *        a consumer that will call methods on {@link List<BuildBatch>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #buildBatches(List<BuildBatch>)
         */
        Builder buildBatches(Consumer<BuildBatch.Builder>... buildBatches);

        /**
         * <p>
         * An array that contains the identifiers of any batch builds that are not found.
         * </p>
         * 
         * @param buildBatchesNotFound
         *        An array that contains the identifiers of any batch builds that are not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildBatchesNotFound(Collection<String> buildBatchesNotFound);

        /**
         * <p>
         * An array that contains the identifiers of any batch builds that are not found.
         * </p>
         * 
         * @param buildBatchesNotFound
         *        An array that contains the identifiers of any batch builds that are not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildBatchesNotFound(String... buildBatchesNotFound);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private List<BuildBatch> buildBatches = DefaultSdkAutoConstructList.getInstance();

        private List<String> buildBatchesNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetBuildBatchesResponse model) {
            super(model);
            buildBatches(model.buildBatches);
            buildBatchesNotFound(model.buildBatchesNotFound);
        }

        public final Collection<BuildBatch.Builder> getBuildBatches() {
            if (buildBatches instanceof SdkAutoConstructList) {
                return null;
            }
            return buildBatches != null ? buildBatches.stream().map(BuildBatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder buildBatches(Collection<BuildBatch> buildBatches) {
            this.buildBatches = BuildBatchesCopier.copy(buildBatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildBatches(BuildBatch... buildBatches) {
            buildBatches(Arrays.asList(buildBatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildBatches(Consumer<BuildBatch.Builder>... buildBatches) {
            buildBatches(Stream.of(buildBatches).map(c -> BuildBatch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBuildBatches(Collection<BuildBatch.BuilderImpl> buildBatches) {
            this.buildBatches = BuildBatchesCopier.copyFromBuilder(buildBatches);
        }

        public final Collection<String> getBuildBatchesNotFound() {
            if (buildBatchesNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return buildBatchesNotFound;
        }

        @Override
        public final Builder buildBatchesNotFound(Collection<String> buildBatchesNotFound) {
            this.buildBatchesNotFound = BuildBatchIdsCopier.copy(buildBatchesNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildBatchesNotFound(String... buildBatchesNotFound) {
            buildBatchesNotFound(Arrays.asList(buildBatchesNotFound));
            return this;
        }

        public final void setBuildBatchesNotFound(Collection<String> buildBatchesNotFound) {
            this.buildBatchesNotFound = BuildBatchIdsCopier.copy(buildBatchesNotFound);
        }

        @Override
        public BatchGetBuildBatchesResponse build() {
            return new BatchGetBuildBatchesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
