/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteBuildsResponse extends CodeBuildResponse implements
        ToCopyableBuilder<BatchDeleteBuildsResponse.Builder, BatchDeleteBuildsResponse> {
    private static final SdkField<List<String>> BUILDS_DELETED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("buildsDeleted")
            .getter(getter(BatchDeleteBuildsResponse::buildsDeleted))
            .setter(setter(Builder::buildsDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildsDeleted").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BuildNotDeleted>> BUILDS_NOT_DELETED_FIELD = SdkField
            .<List<BuildNotDeleted>> builder(MarshallingType.LIST)
            .memberName("buildsNotDeleted")
            .getter(getter(BatchDeleteBuildsResponse::buildsNotDeleted))
            .setter(setter(Builder::buildsNotDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildsNotDeleted").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BuildNotDeleted> builder(MarshallingType.SDK_POJO)
                                            .constructor(BuildNotDeleted::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILDS_DELETED_FIELD,
            BUILDS_NOT_DELETED_FIELD));

    private final List<String> buildsDeleted;

    private final List<BuildNotDeleted> buildsNotDeleted;

    private BatchDeleteBuildsResponse(BuilderImpl builder) {
        super(builder);
        this.buildsDeleted = builder.buildsDeleted;
        this.buildsNotDeleted = builder.buildsNotDeleted;
    }

    /**
     * Returns true if the BuildsDeleted property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasBuildsDeleted() {
        return buildsDeleted != null && !(buildsDeleted instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the builds that were successfully deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBuildsDeleted()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the builds that were successfully deleted.
     */
    public final List<String> buildsDeleted() {
        return buildsDeleted;
    }

    /**
     * Returns true if the BuildsNotDeleted property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasBuildsNotDeleted() {
        return buildsNotDeleted != null && !(buildsNotDeleted instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about any builds that could not be successfully deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBuildsNotDeleted()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about any builds that could not be successfully deleted.
     */
    public final List<BuildNotDeleted> buildsNotDeleted() {
        return buildsNotDeleted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBuildsDeleted() ? buildsDeleted() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBuildsNotDeleted() ? buildsNotDeleted() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteBuildsResponse)) {
            return false;
        }
        BatchDeleteBuildsResponse other = (BatchDeleteBuildsResponse) obj;
        return hasBuildsDeleted() == other.hasBuildsDeleted() && Objects.equals(buildsDeleted(), other.buildsDeleted())
                && hasBuildsNotDeleted() == other.hasBuildsNotDeleted()
                && Objects.equals(buildsNotDeleted(), other.buildsNotDeleted());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteBuildsResponse").add("BuildsDeleted", hasBuildsDeleted() ? buildsDeleted() : null)
                .add("BuildsNotDeleted", hasBuildsNotDeleted() ? buildsNotDeleted() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "buildsDeleted":
            return Optional.ofNullable(clazz.cast(buildsDeleted()));
        case "buildsNotDeleted":
            return Optional.ofNullable(clazz.cast(buildsNotDeleted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteBuildsResponse, T> g) {
        return obj -> g.apply((BatchDeleteBuildsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeleteBuildsResponse> {
        /**
         * <p>
         * The IDs of the builds that were successfully deleted.
         * </p>
         * 
         * @param buildsDeleted
         *        The IDs of the builds that were successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildsDeleted(Collection<String> buildsDeleted);

        /**
         * <p>
         * The IDs of the builds that were successfully deleted.
         * </p>
         * 
         * @param buildsDeleted
         *        The IDs of the builds that were successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildsDeleted(String... buildsDeleted);

        /**
         * <p>
         * Information about any builds that could not be successfully deleted.
         * </p>
         * 
         * @param buildsNotDeleted
         *        Information about any builds that could not be successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildsNotDeleted(Collection<BuildNotDeleted> buildsNotDeleted);

        /**
         * <p>
         * Information about any builds that could not be successfully deleted.
         * </p>
         * 
         * @param buildsNotDeleted
         *        Information about any builds that could not be successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildsNotDeleted(BuildNotDeleted... buildsNotDeleted);

        /**
         * <p>
         * Information about any builds that could not be successfully deleted.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BuildNotDeleted>.Builder} avoiding the need
         * to create one manually via {@link List<BuildNotDeleted>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BuildNotDeleted>.Builder#build()} is called immediately and
         * its result is passed to {@link #buildsNotDeleted(List<BuildNotDeleted>)}.
         * 
         * @param buildsNotDeleted
         *        a consumer that will call methods on {@link List<BuildNotDeleted>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #buildsNotDeleted(List<BuildNotDeleted>)
         */
        Builder buildsNotDeleted(Consumer<BuildNotDeleted.Builder>... buildsNotDeleted);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private List<String> buildsDeleted = DefaultSdkAutoConstructList.getInstance();

        private List<BuildNotDeleted> buildsNotDeleted = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteBuildsResponse model) {
            super(model);
            buildsDeleted(model.buildsDeleted);
            buildsNotDeleted(model.buildsNotDeleted);
        }

        public final Collection<String> getBuildsDeleted() {
            if (buildsDeleted instanceof SdkAutoConstructList) {
                return null;
            }
            return buildsDeleted;
        }

        @Override
        public final Builder buildsDeleted(Collection<String> buildsDeleted) {
            this.buildsDeleted = BuildIdsCopier.copy(buildsDeleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsDeleted(String... buildsDeleted) {
            buildsDeleted(Arrays.asList(buildsDeleted));
            return this;
        }

        public final void setBuildsDeleted(Collection<String> buildsDeleted) {
            this.buildsDeleted = BuildIdsCopier.copy(buildsDeleted);
        }

        public final Collection<BuildNotDeleted.Builder> getBuildsNotDeleted() {
            if (buildsNotDeleted instanceof SdkAutoConstructList) {
                return null;
            }
            return buildsNotDeleted != null ? buildsNotDeleted.stream().map(BuildNotDeleted::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder buildsNotDeleted(Collection<BuildNotDeleted> buildsNotDeleted) {
            this.buildsNotDeleted = BuildsNotDeletedCopier.copy(buildsNotDeleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsNotDeleted(BuildNotDeleted... buildsNotDeleted) {
            buildsNotDeleted(Arrays.asList(buildsNotDeleted));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsNotDeleted(Consumer<BuildNotDeleted.Builder>... buildsNotDeleted) {
            buildsNotDeleted(Stream.of(buildsNotDeleted).map(c -> BuildNotDeleted.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBuildsNotDeleted(Collection<BuildNotDeleted.BuilderImpl> buildsNotDeleted) {
            this.buildsNotDeleted = BuildsNotDeletedCopier.copyFromBuilder(buildsNotDeleted);
        }

        @Override
        public BatchDeleteBuildsResponse build() {
            return new BatchDeleteBuildsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
