/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.SourceCredentialsInfo;
import software.amazon.awssdk.services.codebuild.model.SourceCredentialsInfosCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSourceCredentialsResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, ListSourceCredentialsResponse> {
    private static final SdkField<List<SourceCredentialsInfo>> SOURCE_CREDENTIALS_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceCredentialsInfos").getter(ListSourceCredentialsResponse.getter(ListSourceCredentialsResponse::sourceCredentialsInfos)).setter(ListSourceCredentialsResponse.setter(Builder::sourceCredentialsInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCredentialsInfos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceCredentialsInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_CREDENTIALS_INFOS_FIELD));
    private final List<SourceCredentialsInfo> sourceCredentialsInfos;

    private ListSourceCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.sourceCredentialsInfos = builder.sourceCredentialsInfos;
    }

    public final boolean hasSourceCredentialsInfos() {
        return this.sourceCredentialsInfos != null && !(this.sourceCredentialsInfos instanceof SdkAutoConstructList);
    }

    public final List<SourceCredentialsInfo> sourceCredentialsInfos() {
        return this.sourceCredentialsInfos;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceCredentialsInfos() ? this.sourceCredentialsInfos() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSourceCredentialsResponse)) {
            return false;
        }
        ListSourceCredentialsResponse other = (ListSourceCredentialsResponse)((Object)obj);
        return this.hasSourceCredentialsInfos() == other.hasSourceCredentialsInfos() && Objects.equals(this.sourceCredentialsInfos(), other.sourceCredentialsInfos());
    }

    public final String toString() {
        return ToString.builder((String)"ListSourceCredentialsResponse").add("SourceCredentialsInfos", this.hasSourceCredentialsInfos() ? this.sourceCredentialsInfos() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceCredentialsInfos": {
                return Optional.ofNullable(clazz.cast(this.sourceCredentialsInfos()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSourceCredentialsResponse, T> g) {
        return obj -> g.apply((ListSourceCredentialsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private List<SourceCredentialsInfo> sourceCredentialsInfos = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSourceCredentialsResponse model) {
            super(model);
            this.sourceCredentialsInfos(model.sourceCredentialsInfos);
        }

        public final Collection<SourceCredentialsInfo.Builder> getSourceCredentialsInfos() {
            if (this.sourceCredentialsInfos instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceCredentialsInfos != null ? (Collection)this.sourceCredentialsInfos.stream().map(SourceCredentialsInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sourceCredentialsInfos(Collection<SourceCredentialsInfo> sourceCredentialsInfos) {
            this.sourceCredentialsInfos = SourceCredentialsInfosCopier.copy(sourceCredentialsInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceCredentialsInfos(SourceCredentialsInfo ... sourceCredentialsInfos) {
            this.sourceCredentialsInfos(Arrays.asList(sourceCredentialsInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceCredentialsInfos(Consumer<SourceCredentialsInfo.Builder> ... sourceCredentialsInfos) {
            this.sourceCredentialsInfos(Stream.of(sourceCredentialsInfos).map(c -> (SourceCredentialsInfo)((SourceCredentialsInfo.Builder)SourceCredentialsInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSourceCredentialsInfos(Collection<SourceCredentialsInfo.BuilderImpl> sourceCredentialsInfos) {
            this.sourceCredentialsInfos = SourceCredentialsInfosCopier.copyFromBuilder(sourceCredentialsInfos);
        }

        @Override
        public ListSourceCredentialsResponse build() {
            return new ListSourceCredentialsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSourceCredentialsResponse> {
        public Builder sourceCredentialsInfos(Collection<SourceCredentialsInfo> var1);

        public Builder sourceCredentialsInfos(SourceCredentialsInfo ... var1);

        public Builder sourceCredentialsInfos(Consumer<SourceCredentialsInfo.Builder> ... var1);
    }
}

