/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectResponse;

public class ListBuildsForProjectPublisher
implements SdkPublisher<ListBuildsForProjectResponse> {
    private final CodeBuildAsyncClient client;
    private final ListBuildsForProjectRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBuildsForProjectPublisher(CodeBuildAsyncClient client, ListBuildsForProjectRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBuildsForProjectPublisher(CodeBuildAsyncClient client, ListBuildsForProjectRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBuildsForProjectResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBuildsForProjectResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> ids() {
        Function<ListBuildsForProjectResponse, Iterator> getIterator = response -> {
            if (response != null && response.ids() != null) {
                return response.ids().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBuildsForProjectResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBuildsForProjectResponseFetcher
    implements AsyncPageFetcher<ListBuildsForProjectResponse> {
        private ListBuildsForProjectResponseFetcher() {
        }

        public boolean hasNextPage(ListBuildsForProjectResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBuildsForProjectResponse> nextPage(ListBuildsForProjectResponse previousPage) {
            if (previousPage == null) {
                return ListBuildsForProjectPublisher.this.client.listBuildsForProject(ListBuildsForProjectPublisher.this.firstRequest);
            }
            return ListBuildsForProjectPublisher.this.client.listBuildsForProject((ListBuildsForProjectRequest)((Object)ListBuildsForProjectPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

