/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.Report;
import software.amazon.awssdk.services.codebuild.model.ReportArnsCopier;
import software.amazon.awssdk.services.codebuild.model.ReportsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetReportsResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, BatchGetReportsResponse> {
    private static final SdkField<List<Report>> REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reports").getter(BatchGetReportsResponse.getter(BatchGetReportsResponse::reports)).setter(BatchGetReportsResponse.setter(Builder::reports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Report::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REPORTS_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reportsNotFound").getter(BatchGetReportsResponse.getter(BatchGetReportsResponse::reportsNotFound)).setter(BatchGetReportsResponse.setter(Builder::reportsNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportsNotFound").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORTS_FIELD, REPORTS_NOT_FOUND_FIELD));
    private final List<Report> reports;
    private final List<String> reportsNotFound;

    private BatchGetReportsResponse(BuilderImpl builder) {
        super(builder);
        this.reports = builder.reports;
        this.reportsNotFound = builder.reportsNotFound;
    }

    public boolean hasReports() {
        return this.reports != null && !(this.reports instanceof SdkAutoConstructList);
    }

    public List<Report> reports() {
        return this.reports;
    }

    public boolean hasReportsNotFound() {
        return this.reportsNotFound != null && !(this.reportsNotFound instanceof SdkAutoConstructList);
    }

    public List<String> reportsNotFound() {
        return this.reportsNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReports() ? this.reports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportsNotFound() ? this.reportsNotFound() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetReportsResponse)) {
            return false;
        }
        BatchGetReportsResponse other = (BatchGetReportsResponse)((Object)obj);
        return this.hasReports() == other.hasReports() && Objects.equals(this.reports(), other.reports()) && this.hasReportsNotFound() == other.hasReportsNotFound() && Objects.equals(this.reportsNotFound(), other.reportsNotFound());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetReportsResponse").add("Reports", this.hasReports() ? this.reports() : null).add("ReportsNotFound", this.hasReportsNotFound() ? this.reportsNotFound() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reports": {
                return Optional.ofNullable(clazz.cast(this.reports()));
            }
            case "reportsNotFound": {
                return Optional.ofNullable(clazz.cast(this.reportsNotFound()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetReportsResponse, T> g) {
        return obj -> g.apply((BatchGetReportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private List<Report> reports = DefaultSdkAutoConstructList.getInstance();
        private List<String> reportsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetReportsResponse model) {
            super(model);
            this.reports(model.reports);
            this.reportsNotFound(model.reportsNotFound);
        }

        public final Collection<Report.Builder> getReports() {
            if (this.reports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reports != null ? (Collection)this.reports.stream().map(Report::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reports(Collection<Report> reports) {
            this.reports = ReportsCopier.copy(reports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(Report ... reports) {
            this.reports(Arrays.asList(reports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(Consumer<Report.Builder> ... reports) {
            this.reports(Stream.of(reports).map(c -> (Report)((Report.Builder)Report.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReports(Collection<Report.BuilderImpl> reports) {
            this.reports = ReportsCopier.copyFromBuilder(reports);
        }

        public final Collection<String> getReportsNotFound() {
            if (this.reportsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reportsNotFound;
        }

        @Override
        public final Builder reportsNotFound(Collection<String> reportsNotFound) {
            this.reportsNotFound = ReportArnsCopier.copy(reportsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportsNotFound(String ... reportsNotFound) {
            this.reportsNotFound(Arrays.asList(reportsNotFound));
            return this;
        }

        public final void setReportsNotFound(Collection<String> reportsNotFound) {
            this.reportsNotFound = ReportArnsCopier.copy(reportsNotFound);
        }

        @Override
        public BatchGetReportsResponse build() {
            return new BatchGetReportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetReportsResponse> {
        public Builder reports(Collection<Report> var1);

        public Builder reports(Report ... var1);

        public Builder reports(Consumer<Report.Builder> ... var1);

        public Builder reportsNotFound(Collection<String> var1);

        public Builder reportsNotFound(String ... var1);
    }
}

