/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StatusType {
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    FAULT("FAULT"),
    TIMED_OUT("TIMED_OUT"),
    IN_PROGRESS("IN_PROGRESS"),
    STOPPED("STOPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StatusType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StatusType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StatusType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StatusType> knownValues() {
        return Stream.of(StatusType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

