/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.ReportCodeCoverageSortByType;
import software.amazon.awssdk.services.codebuild.model.SortOrderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCodeCoveragesRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, DescribeCodeCoveragesRequest> {
    private static final SdkField<String> REPORT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeCodeCoveragesRequest.getter(DescribeCodeCoveragesRequest::reportArn)).setter(DescribeCodeCoveragesRequest.setter(Builder::reportArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportArn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeCodeCoveragesRequest.getter(DescribeCodeCoveragesRequest::nextToken)).setter(DescribeCodeCoveragesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeCodeCoveragesRequest.getter(DescribeCodeCoveragesRequest::maxResults)).setter(DescribeCodeCoveragesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeCodeCoveragesRequest.getter(DescribeCodeCoveragesRequest::sortOrderAsString)).setter(DescribeCodeCoveragesRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeCodeCoveragesRequest.getter(DescribeCodeCoveragesRequest::sortByAsString)).setter(DescribeCodeCoveragesRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<Double> MIN_LINE_COVERAGE_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(DescribeCodeCoveragesRequest.getter(DescribeCodeCoveragesRequest::minLineCoveragePercentage)).setter(DescribeCodeCoveragesRequest.setter(Builder::minLineCoveragePercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minLineCoveragePercentage").build()}).build();
    private static final SdkField<Double> MAX_LINE_COVERAGE_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(DescribeCodeCoveragesRequest.getter(DescribeCodeCoveragesRequest::maxLineCoveragePercentage)).setter(DescribeCodeCoveragesRequest.setter(Builder::maxLineCoveragePercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLineCoveragePercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ARN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SORT_ORDER_FIELD, SORT_BY_FIELD, MIN_LINE_COVERAGE_PERCENTAGE_FIELD, MAX_LINE_COVERAGE_PERCENTAGE_FIELD));
    private final String reportArn;
    private final String nextToken;
    private final Integer maxResults;
    private final String sortOrder;
    private final String sortBy;
    private final Double minLineCoveragePercentage;
    private final Double maxLineCoveragePercentage;

    private DescribeCodeCoveragesRequest(BuilderImpl builder) {
        super(builder);
        this.reportArn = builder.reportArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sortOrder = builder.sortOrder;
        this.sortBy = builder.sortBy;
        this.minLineCoveragePercentage = builder.minLineCoveragePercentage;
        this.maxLineCoveragePercentage = builder.maxLineCoveragePercentage;
    }

    public String reportArn() {
        return this.reportArn;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public SortOrderType sortOrder() {
        return SortOrderType.fromValue(this.sortOrder);
    }

    public String sortOrderAsString() {
        return this.sortOrder;
    }

    public ReportCodeCoverageSortByType sortBy() {
        return ReportCodeCoverageSortByType.fromValue(this.sortBy);
    }

    public String sortByAsString() {
        return this.sortBy;
    }

    public Double minLineCoveragePercentage() {
        return this.minLineCoveragePercentage;
    }

    public Double maxLineCoveragePercentage() {
        return this.maxLineCoveragePercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minLineCoveragePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLineCoveragePercentage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCodeCoveragesRequest)) {
            return false;
        }
        DescribeCodeCoveragesRequest other = (DescribeCodeCoveragesRequest)((Object)obj);
        return Objects.equals(this.reportArn(), other.reportArn()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.minLineCoveragePercentage(), other.minLineCoveragePercentage()) && Objects.equals(this.maxLineCoveragePercentage(), other.maxLineCoveragePercentage());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCodeCoveragesRequest").add("ReportArn", (Object)this.reportArn()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("SortOrder", (Object)this.sortOrderAsString()).add("SortBy", (Object)this.sortByAsString()).add("MinLineCoveragePercentage", (Object)this.minLineCoveragePercentage()).add("MaxLineCoveragePercentage", (Object)this.maxLineCoveragePercentage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reportArn": {
                return Optional.ofNullable(clazz.cast(this.reportArn()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "minLineCoveragePercentage": {
                return Optional.ofNullable(clazz.cast(this.minLineCoveragePercentage()));
            }
            case "maxLineCoveragePercentage": {
                return Optional.ofNullable(clazz.cast(this.maxLineCoveragePercentage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCodeCoveragesRequest, T> g) {
        return obj -> g.apply((DescribeCodeCoveragesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String reportArn;
        private String nextToken;
        private Integer maxResults;
        private String sortOrder;
        private String sortBy;
        private Double minLineCoveragePercentage;
        private Double maxLineCoveragePercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCodeCoveragesRequest model) {
            super(model);
            this.reportArn(model.reportArn);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.sortOrder(model.sortOrder);
            this.sortBy(model.sortBy);
            this.minLineCoveragePercentage(model.minLineCoveragePercentage);
            this.maxLineCoveragePercentage(model.maxLineCoveragePercentage);
        }

        public final String getReportArn() {
            return this.reportArn;
        }

        @Override
        public final Builder reportArn(String reportArn) {
            this.reportArn = reportArn;
            return this;
        }

        public final void setReportArn(String reportArn) {
            this.reportArn = reportArn;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrderType sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ReportCodeCoverageSortByType sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final Double getMinLineCoveragePercentage() {
            return this.minLineCoveragePercentage;
        }

        @Override
        public final Builder minLineCoveragePercentage(Double minLineCoveragePercentage) {
            this.minLineCoveragePercentage = minLineCoveragePercentage;
            return this;
        }

        public final void setMinLineCoveragePercentage(Double minLineCoveragePercentage) {
            this.minLineCoveragePercentage = minLineCoveragePercentage;
        }

        public final Double getMaxLineCoveragePercentage() {
            return this.maxLineCoveragePercentage;
        }

        @Override
        public final Builder maxLineCoveragePercentage(Double maxLineCoveragePercentage) {
            this.maxLineCoveragePercentage = maxLineCoveragePercentage;
            return this;
        }

        public final void setMaxLineCoveragePercentage(Double maxLineCoveragePercentage) {
            this.maxLineCoveragePercentage = maxLineCoveragePercentage;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCodeCoveragesRequest build() {
            return new DescribeCodeCoveragesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCodeCoveragesRequest> {
        public Builder reportArn(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrderType var1);

        public Builder sortBy(String var1);

        public Builder sortBy(ReportCodeCoverageSortByType var1);

        public Builder minLineCoveragePercentage(Double var1);

        public Builder maxLineCoveragePercentage(Double var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

