/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.CredentialProviderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegistryCredential
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegistryCredential> {
    private static final SdkField<String> CREDENTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegistryCredential.getter(RegistryCredential::credential)).setter(RegistryCredential.setter(Builder::credential)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credential").build()}).build();
    private static final SdkField<String> CREDENTIAL_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegistryCredential.getter(RegistryCredential::credentialProviderAsString)).setter(RegistryCredential.setter(Builder::credentialProvider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialProvider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIAL_FIELD, CREDENTIAL_PROVIDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String credential;
    private final String credentialProvider;

    private RegistryCredential(BuilderImpl builder) {
        this.credential = builder.credential;
        this.credentialProvider = builder.credentialProvider;
    }

    public String credential() {
        return this.credential;
    }

    public CredentialProviderType credentialProvider() {
        return CredentialProviderType.fromValue(this.credentialProvider);
    }

    public String credentialProviderAsString() {
        return this.credentialProvider;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.credential());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialProviderAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistryCredential)) {
            return false;
        }
        RegistryCredential other = (RegistryCredential)obj;
        return Objects.equals(this.credential(), other.credential()) && Objects.equals(this.credentialProviderAsString(), other.credentialProviderAsString());
    }

    public String toString() {
        return ToString.builder((String)"RegistryCredential").add("Credential", (Object)this.credential()).add("CredentialProvider", (Object)this.credentialProviderAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "credential": {
                return Optional.ofNullable(clazz.cast(this.credential()));
            }
            case "credentialProvider": {
                return Optional.ofNullable(clazz.cast(this.credentialProviderAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegistryCredential, T> g) {
        return obj -> g.apply((RegistryCredential)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String credential;
        private String credentialProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistryCredential model) {
            this.credential(model.credential);
            this.credentialProvider(model.credentialProvider);
        }

        public final String getCredential() {
            return this.credential;
        }

        @Override
        public final Builder credential(String credential) {
            this.credential = credential;
            return this;
        }

        public final void setCredential(String credential) {
            this.credential = credential;
        }

        public final String getCredentialProvider() {
            return this.credentialProvider;
        }

        @Override
        public final Builder credentialProvider(String credentialProvider) {
            this.credentialProvider = credentialProvider;
            return this;
        }

        @Override
        public final Builder credentialProvider(CredentialProviderType credentialProvider) {
            this.credentialProvider(credentialProvider == null ? null : credentialProvider.toString());
            return this;
        }

        public final void setCredentialProvider(String credentialProvider) {
            this.credentialProvider = credentialProvider;
        }

        public RegistryCredential build() {
            return new RegistryCredential(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegistryCredential> {
        public Builder credential(String var1);

        public Builder credentialProvider(String var1);

        public Builder credentialProvider(CredentialProviderType var1);
    }
}

