/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the S3 bucket where the raw data of a report are exported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ReportExportConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ReportExportConfig.Builder, S3ReportExportConfig> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3ReportExportConfig::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3ReportExportConfig::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final SdkField<String> PACKAGING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3ReportExportConfig::packagingAsString)).setter(setter(Builder::packaging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packaging").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3ReportExportConfig::encryptionKey)).setter(setter(Builder::encryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()).build();

    private static final SdkField<Boolean> ENCRYPTION_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(S3ReportExportConfig::encryptionDisabled)).setter(setter(Builder::encryptionDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionDisabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, PATH_FIELD,
            PACKAGING_FIELD, ENCRYPTION_KEY_FIELD, ENCRYPTION_DISABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final String path;

    private final String packaging;

    private final String encryptionKey;

    private final Boolean encryptionDisabled;

    private S3ReportExportConfig(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.path = builder.path;
        this.packaging = builder.packaging;
        this.encryptionKey = builder.encryptionKey;
        this.encryptionDisabled = builder.encryptionDisabled;
    }

    /**
     * <p>
     * The name of the S3 bucket where the raw data of a report are exported.
     * </p>
     * 
     * @return The name of the S3 bucket where the raw data of a report are exported.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The path to the exported report's raw data results.
     * </p>
     * 
     * @return The path to the exported report's raw data results.
     */
    public String path() {
        return path;
    }

    /**
     * <p>
     * The type of build output artifact to create. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: AWS CodeBuild creates the raw data in the output bucket. This is the default if packaging is
     * not specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ZIP</code>: AWS CodeBuild creates a ZIP file with the raw data in the output bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packaging} will
     * return {@link ReportPackagingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #packagingAsString}.
     * </p>
     * 
     * @return The type of build output artifact to create. Valid values include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: AWS CodeBuild creates the raw data in the output bucket. This is the default if
     *         packaging is not specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ZIP</code>: AWS CodeBuild creates a ZIP file with the raw data in the output bucket.
     *         </p>
     *         </li>
     * @see ReportPackagingType
     */
    public ReportPackagingType packaging() {
        return ReportPackagingType.fromValue(packaging);
    }

    /**
     * <p>
     * The type of build output artifact to create. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: AWS CodeBuild creates the raw data in the output bucket. This is the default if packaging is
     * not specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ZIP</code>: AWS CodeBuild creates a ZIP file with the raw data in the output bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packaging} will
     * return {@link ReportPackagingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #packagingAsString}.
     * </p>
     * 
     * @return The type of build output artifact to create. Valid values include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: AWS CodeBuild creates the raw data in the output bucket. This is the default if
     *         packaging is not specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ZIP</code>: AWS CodeBuild creates a ZIP file with the raw data in the output bucket.
     *         </p>
     *         </li>
     * @see ReportPackagingType
     */
    public String packagingAsString() {
        return packaging;
    }

    /**
     * <p>
     * The encryption key for the report's encrypted raw data.
     * </p>
     * 
     * @return The encryption key for the report's encrypted raw data.
     */
    public String encryptionKey() {
        return encryptionKey;
    }

    /**
     * <p>
     * A boolean value that specifies if the results of a report are encrypted.
     * </p>
     * 
     * @return A boolean value that specifies if the results of a report are encrypted.
     */
    public Boolean encryptionDisabled() {
        return encryptionDisabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(packagingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionDisabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ReportExportConfig)) {
            return false;
        }
        S3ReportExportConfig other = (S3ReportExportConfig) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(path(), other.path())
                && Objects.equals(packagingAsString(), other.packagingAsString())
                && Objects.equals(encryptionKey(), other.encryptionKey())
                && Objects.equals(encryptionDisabled(), other.encryptionDisabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("S3ReportExportConfig").add("Bucket", bucket()).add("Path", path())
                .add("Packaging", packagingAsString()).add("EncryptionKey", encryptionKey())
                .add("EncryptionDisabled", encryptionDisabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "packaging":
            return Optional.ofNullable(clazz.cast(packagingAsString()));
        case "encryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "encryptionDisabled":
            return Optional.ofNullable(clazz.cast(encryptionDisabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ReportExportConfig, T> g) {
        return obj -> g.apply((S3ReportExportConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ReportExportConfig> {
        /**
         * <p>
         * The name of the S3 bucket where the raw data of a report are exported.
         * </p>
         * 
         * @param bucket
         *        The name of the S3 bucket where the raw data of a report are exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The path to the exported report's raw data results.
         * </p>
         * 
         * @param path
         *        The path to the exported report's raw data results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The type of build output artifact to create. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: AWS CodeBuild creates the raw data in the output bucket. This is the default if packaging
         * is not specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ZIP</code>: AWS CodeBuild creates a ZIP file with the raw data in the output bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param packaging
         *        The type of build output artifact to create. Valid values include: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: AWS CodeBuild creates the raw data in the output bucket. This is the default if
         *        packaging is not specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ZIP</code>: AWS CodeBuild creates a ZIP file with the raw data in the output bucket.
         *        </p>
         *        </li>
         * @see ReportPackagingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportPackagingType
         */
        Builder packaging(String packaging);

        /**
         * <p>
         * The type of build output artifact to create. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: AWS CodeBuild creates the raw data in the output bucket. This is the default if packaging
         * is not specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ZIP</code>: AWS CodeBuild creates a ZIP file with the raw data in the output bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param packaging
         *        The type of build output artifact to create. Valid values include: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: AWS CodeBuild creates the raw data in the output bucket. This is the default if
         *        packaging is not specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ZIP</code>: AWS CodeBuild creates a ZIP file with the raw data in the output bucket.
         *        </p>
         *        </li>
         * @see ReportPackagingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportPackagingType
         */
        Builder packaging(ReportPackagingType packaging);

        /**
         * <p>
         * The encryption key for the report's encrypted raw data.
         * </p>
         * 
         * @param encryptionKey
         *        The encryption key for the report's encrypted raw data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(String encryptionKey);

        /**
         * <p>
         * A boolean value that specifies if the results of a report are encrypted.
         * </p>
         * 
         * @param encryptionDisabled
         *        A boolean value that specifies if the results of a report are encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionDisabled(Boolean encryptionDisabled);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String path;

        private String packaging;

        private String encryptionKey;

        private Boolean encryptionDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ReportExportConfig model) {
            bucket(model.bucket);
            path(model.path);
            packaging(model.packaging);
            encryptionKey(model.encryptionKey);
            encryptionDisabled(model.encryptionDisabled);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getPackaging() {
            return packaging;
        }

        @Override
        public final Builder packaging(String packaging) {
            this.packaging = packaging;
            return this;
        }

        @Override
        public final Builder packaging(ReportPackagingType packaging) {
            this.packaging(packaging == null ? null : packaging.toString());
            return this;
        }

        public final void setPackaging(String packaging) {
            this.packaging = packaging;
        }

        public final String getEncryptionKey() {
            return encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        public final Boolean getEncryptionDisabled() {
            return encryptionDisabled;
        }

        @Override
        public final Builder encryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
            return this;
        }

        public final void setEncryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
        }

        @Override
        public S3ReportExportConfig build() {
            return new S3ReportExportConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
