/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReportsResponse extends CodeBuildResponse implements
        ToCopyableBuilder<ListReportsResponse.Builder, ListReportsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListReportsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<String>> REPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListReportsResponse::reports))
            .setter(setter(Builder::reports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            REPORTS_FIELD));

    private final String nextToken;

    private final List<String> reports;

    private ListReportsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reports = builder.reports;
    }

    /**
     * <p>
     * During a previous call, the maximum number of items that can be returned is the value specified in
     * <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is
     * returned. To get the next batch of items in the list, call this operation again, adding the next token to the
     * call. To get all of the items in the list, keep calling this operation with each subsequent next token that is
     * returned, until no more next tokens are returned.
     * </p>
     * 
     * @return During a previous call, the maximum number of items that can be returned is the value specified in
     *         <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
     *         is returned. To get the next batch of items in the list, call this operation again, adding the next token
     *         to the call. To get all of the items in the list, keep calling this operation with each subsequent next
     *         token that is returned, until no more next tokens are returned.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Reports property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasReports() {
        return reports != null && !(reports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of returned ARNs for the reports in the current AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReports()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of returned ARNs for the reports in the current AWS account.
     */
    public List<String> reports() {
        return reports;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(reports());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReportsResponse)) {
            return false;
        }
        ListReportsResponse other = (ListReportsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(reports(), other.reports());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListReportsResponse").add("NextToken", nextToken()).add("Reports", reports()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "reports":
            return Optional.ofNullable(clazz.cast(reports()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReportsResponse, T> g) {
        return obj -> g.apply((ListReportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListReportsResponse> {
        /**
         * <p>
         * During a previous call, the maximum number of items that can be returned is the value specified in
         * <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is
         * returned. To get the next batch of items in the list, call this operation again, adding the next token to the
         * call. To get all of the items in the list, keep calling this operation with each subsequent next token that
         * is returned, until no more next tokens are returned.
         * </p>
         * 
         * @param nextToken
         *        During a previous call, the maximum number of items that can be returned is the value specified in
         *        <code>maxResults</code>. If there more items in the list, then a unique string called a
         *        <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again,
         *        adding the next token to the call. To get all of the items in the list, keep calling this operation
         *        with each subsequent next token that is returned, until no more next tokens are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of returned ARNs for the reports in the current AWS account.
         * </p>
         * 
         * @param reports
         *        The list of returned ARNs for the reports in the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reports(Collection<String> reports);

        /**
         * <p>
         * The list of returned ARNs for the reports in the current AWS account.
         * </p>
         * 
         * @param reports
         *        The list of returned ARNs for the reports in the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reports(String... reports);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<String> reports = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReportsResponse model) {
            super(model);
            nextToken(model.nextToken);
            reports(model.reports);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getReports() {
            return reports;
        }

        @Override
        public final Builder reports(Collection<String> reports) {
            this.reports = ReportArnsCopier.copy(reports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(String... reports) {
            reports(Arrays.asList(reports));
            return this;
        }

        public final void setReports(Collection<String> reports) {
            this.reports = ReportArnsCopier.copy(reports);
        }

        @Override
        public ListReportsResponse build() {
            return new ListReportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
