/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.LogsConfigStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchLogsConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchLogsConfig> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CloudWatchLogsConfig.getter(CloudWatchLogsConfig::statusAsString)).setter(CloudWatchLogsConfig.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CloudWatchLogsConfig.getter(CloudWatchLogsConfig::groupName)).setter(CloudWatchLogsConfig.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupName").build()}).build();
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CloudWatchLogsConfig.getter(CloudWatchLogsConfig::streamName)).setter(CloudWatchLogsConfig.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, GROUP_NAME_FIELD, STREAM_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String groupName;
    private final String streamName;

    private CloudWatchLogsConfig(BuilderImpl builder) {
        this.status = builder.status;
        this.groupName = builder.groupName;
        this.streamName = builder.streamName;
    }

    public LogsConfigStatusType status() {
        return LogsConfigStatusType.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String groupName() {
        return this.groupName;
    }

    public String streamName() {
        return this.streamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsConfig)) {
            return false;
        }
        CloudWatchLogsConfig other = (CloudWatchLogsConfig)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.streamName(), other.streamName());
    }

    public String toString() {
        return ToString.builder((String)"CloudWatchLogsConfig").add("Status", (Object)this.statusAsString()).add("GroupName", (Object)this.groupName()).add("StreamName", (Object)this.streamName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "groupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "streamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLogsConfig, T> g) {
        return obj -> g.apply((CloudWatchLogsConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String groupName;
        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogsConfig model) {
            this.status(model.status);
            this.groupName(model.groupName);
            this.streamName(model.streamName);
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LogsConfigStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public CloudWatchLogsConfig build() {
            return new CloudWatchLogsConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchLogsConfig> {
        public Builder status(String var1);

        public Builder status(LogsConfigStatusType var1);

        public Builder groupName(String var1);

        public Builder streamName(String var1);
    }
}

