/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.PhaseContext;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PhaseContextMarshaller {
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusCode").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").isBinary(false).build();
    private static final PhaseContextMarshaller INSTANCE = new PhaseContextMarshaller();

    private PhaseContextMarshaller() {
    }

    public static PhaseContextMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PhaseContext phaseContext, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)phaseContext, (String)"phaseContext");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)phaseContext.statusCode(), STATUSCODE_BINDING);
            protocolMarshaller.marshall((Object)phaseContext.message(), MESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

