/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.ListProjectsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListProjectsRequestModelMarshaller {
    private static final MarshallingInfo<String> SORTBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sortBy").isBinary(false).build();
    private static final MarshallingInfo<String> SORTORDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sortOrder").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextToken").isBinary(false).build();
    private static final ListProjectsRequestModelMarshaller INSTANCE = new ListProjectsRequestModelMarshaller();

    private ListProjectsRequestModelMarshaller() {
    }

    public static ListProjectsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListProjectsRequest listProjectsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listProjectsRequest), (String)"listProjectsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listProjectsRequest.sortByString(), SORTBY_BINDING);
            protocolMarshaller.marshall((Object)listProjectsRequest.sortOrderString(), SORTORDER_BINDING);
            protocolMarshaller.marshall((Object)listProjectsRequest.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

