/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.ProjectEnvironment;

@SdkInternalApi
public class ProjectEnvironmentMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("image").build();
    private static final MarshallingInfo<String> COMPUTETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("computeType").build();
    private static final MarshallingInfo<List> ENVIRONMENTVARIABLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environmentVariables").build();
    private static final MarshallingInfo<Boolean> PRIVILEGEDMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("privilegedMode").build();
    private static final ProjectEnvironmentMarshaller INSTANCE = new ProjectEnvironmentMarshaller();

    public static ProjectEnvironmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProjectEnvironment projectEnvironment, ProtocolMarshaller protocolMarshaller) {
        if (projectEnvironment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)projectEnvironment.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)projectEnvironment.image(), IMAGE_BINDING);
            protocolMarshaller.marshall((Object)projectEnvironment.computeTypeString(), COMPUTETYPE_BINDING);
            protocolMarshaller.marshall(projectEnvironment.environmentVariables(), ENVIRONMENTVARIABLES_BINDING);
            protocolMarshaller.marshall((Object)projectEnvironment.privilegedMode(), PRIVILEGEDMODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

