/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.codebuild.model.BuildIdsCopier;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchDeleteBuildsRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, BatchDeleteBuildsRequest> {
    private final List<String> ids;

    private BatchDeleteBuildsRequest(BuilderImpl builder) {
        super(builder);
        this.ids = builder.ids;
    }

    public List<String> ids() {
        return this.ids;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ids());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteBuildsRequest)) {
            return false;
        }
        BatchDeleteBuildsRequest other = (BatchDeleteBuildsRequest)((Object)obj);
        return Objects.equals(this.ids(), other.ids());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ids() != null) {
            sb.append("Ids: ").append(this.ids()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ids": {
                return Optional.of(clazz.cast(this.ids()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private List<String> ids;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteBuildsRequest model) {
            this.ids(model.ids);
        }

        public final Collection<String> getIds() {
            return this.ids;
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = BuildIdsCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String ... ids) {
            this.ids(Arrays.asList(ids));
            return this;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = BuildIdsCopier.copy(ids);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteBuildsRequest build() {
            return new BatchDeleteBuildsRequest(this);
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    CopyableBuilder<Builder, BatchDeleteBuildsRequest> {
        public Builder ids(Collection<String> var1);

        public Builder ids(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

