/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.BuildArtifacts;

@SdkInternalApi
public class BuildArtifactsMarshaller {
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> SHA256SUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sha256sum").build();
    private static final MarshallingInfo<String> MD5SUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("md5sum").build();
    private static final BuildArtifactsMarshaller INSTANCE = new BuildArtifactsMarshaller();

    public static BuildArtifactsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BuildArtifacts buildArtifacts, ProtocolMarshaller protocolMarshaller) {
        if (buildArtifacts == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)buildArtifacts.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)buildArtifacts.sha256sum(), SHA256SUM_BINDING);
            protocolMarshaller.marshall((Object)buildArtifacts.md5sum(), MD5SUM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

