/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codebuild.model.SortOrderType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListBuildsForProjectRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListBuildsForProjectRequest> {
    private final String projectName;
    private final String sortOrder;
    private final String nextToken;

    private ListBuildsForProjectRequest(BuilderImpl builder) {
        this.projectName = builder.projectName;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
    }

    public String projectName() {
        return this.projectName;
    }

    public SortOrderType sortOrder() {
        return SortOrderType.fromValue(this.sortOrder);
    }

    public String sortOrderString() {
        return this.sortOrder;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuildsForProjectRequest)) {
            return false;
        }
        ListBuildsForProjectRequest other = (ListBuildsForProjectRequest)((Object)obj);
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.sortOrderString(), other.sortOrderString()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.projectName() != null) {
            sb.append("ProjectName: ").append(this.projectName()).append(",");
        }
        if (this.sortOrderString() != null) {
            sb.append("SortOrder: ").append(this.sortOrderString()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectName": {
                return Optional.of(clazz.cast(this.projectName()));
            }
            case "sortOrder": {
                return Optional.of(clazz.cast(this.sortOrderString()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String projectName;
        private String sortOrder;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBuildsForProjectRequest model) {
            this.projectName(model.projectName);
            this.sortOrder(model.sortOrder);
            this.nextToken(model.nextToken);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrderType sortOrder) {
            this.sortOrder(sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListBuildsForProjectRequest build() {
            return new ListBuildsForProjectRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListBuildsForProjectRequest> {
        public Builder projectName(String var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrderType var1);

        public Builder nextToken(String var1);
    }
}

