/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.EnvironmentLanguage;
import software.amazon.awssdk.services.codebuild.model.EnvironmentLanguagesCopier;
import software.amazon.awssdk.services.codebuild.model.PlatformType;
import software.amazon.awssdk.services.codebuild.transform.EnvironmentPlatformMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnvironmentPlatform
implements StructuredPojo,
ToCopyableBuilder<Builder, EnvironmentPlatform> {
    private final String platform;
    private final List<EnvironmentLanguage> languages;

    private EnvironmentPlatform(BuilderImpl builder) {
        this.platform = builder.platform;
        this.languages = builder.languages;
    }

    public PlatformType platform() {
        return PlatformType.fromValue(this.platform);
    }

    public String platformString() {
        return this.platform;
    }

    public List<EnvironmentLanguage> languages() {
        return this.languages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.platformString() == null ? 0 : this.platformString().hashCode());
        hashCode = 31 * hashCode + (this.languages() == null ? 0 : this.languages().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentPlatform)) {
            return false;
        }
        EnvironmentPlatform other = (EnvironmentPlatform)obj;
        if (other.platformString() == null ^ this.platformString() == null) {
            return false;
        }
        if (other.platformString() != null && !other.platformString().equals(this.platformString())) {
            return false;
        }
        if (other.languages() == null ^ this.languages() == null) {
            return false;
        }
        return other.languages() == null || other.languages().equals(this.languages());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.platformString() != null) {
            sb.append("Platform: ").append(this.platformString()).append(",");
        }
        if (this.languages() != null) {
            sb.append("Languages: ").append(this.languages()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "platform": {
                return Optional.of(clazz.cast(this.platformString()));
            }
            case "languages": {
                return Optional.of(clazz.cast(this.languages()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentPlatformMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String platform;
        private List<EnvironmentLanguage> languages;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentPlatform model) {
            this.platform(model.platform);
            this.languages(model.languages);
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Collection<EnvironmentLanguage.Builder> getLanguages() {
            return this.languages != null ? (Collection)this.languages.stream().map(EnvironmentLanguage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder languages(Collection<EnvironmentLanguage> languages) {
            this.languages = EnvironmentLanguagesCopier.copy(languages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(EnvironmentLanguage ... languages) {
            this.languages(Arrays.asList(languages));
            return this;
        }

        public final void setLanguages(Collection<EnvironmentLanguage.BuilderImpl> languages) {
            this.languages = EnvironmentLanguagesCopier.copyFromBuilder(languages);
        }

        public EnvironmentPlatform build() {
            return new EnvironmentPlatform(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentPlatform> {
        public Builder platform(String var1);

        public Builder platform(PlatformType var1);

        public Builder languages(Collection<EnvironmentLanguage> var1);

        public Builder languages(EnvironmentLanguage ... var1);
    }
}

