/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codebuild.model.BuildIdsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetBuildsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchGetBuildsRequest> {
    private final List<String> ids;

    private BatchGetBuildsRequest(BuilderImpl builder) {
        this.ids = builder.ids;
    }

    public List<String> ids() {
        return this.ids;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ids() == null ? 0 : this.ids().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetBuildsRequest)) {
            return false;
        }
        BatchGetBuildsRequest other = (BatchGetBuildsRequest)((Object)obj);
        if (other.ids() == null ^ this.ids() == null) {
            return false;
        }
        return other.ids() == null || other.ids().equals(this.ids());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ids() != null) {
            sb.append("Ids: ").append(this.ids()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ids": {
                return Optional.of(clazz.cast(this.ids()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> ids;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetBuildsRequest model) {
            this.ids(model.ids);
        }

        public final Collection<String> getIds() {
            return this.ids;
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = BuildIdsCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String ... ids) {
            this.ids(Arrays.asList(ids));
            return this;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = BuildIdsCopier.copy(ids);
        }

        public BatchGetBuildsRequest build() {
            return new BatchGetBuildsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetBuildsRequest> {
        public Builder ids(Collection<String> var1);

        public Builder ids(String ... var1);
    }
}

