/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.ArtifactNamespace;
import software.amazon.awssdk.services.codebuild.model.ArtifactPackaging;
import software.amazon.awssdk.services.codebuild.model.ArtifactsType;
import software.amazon.awssdk.services.codebuild.transform.ProjectArtifactsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProjectArtifacts
implements StructuredPojo,
ToCopyableBuilder<Builder, ProjectArtifacts> {
    private final String type;
    private final String location;
    private final String path;
    private final String namespaceType;
    private final String name;
    private final String packaging;

    private ProjectArtifacts(BuilderImpl builder) {
        this.type = builder.type;
        this.location = builder.location;
        this.path = builder.path;
        this.namespaceType = builder.namespaceType;
        this.name = builder.name;
        this.packaging = builder.packaging;
    }

    public String type() {
        return this.type;
    }

    public String location() {
        return this.location;
    }

    public String path() {
        return this.path;
    }

    public String namespaceType() {
        return this.namespaceType;
    }

    public String name() {
        return this.name;
    }

    public String packaging() {
        return this.packaging;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        hashCode = 31 * hashCode + (this.path() == null ? 0 : this.path().hashCode());
        hashCode = 31 * hashCode + (this.namespaceType() == null ? 0 : this.namespaceType().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.packaging() == null ? 0 : this.packaging().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectArtifacts)) {
            return false;
        }
        ProjectArtifacts other = (ProjectArtifacts)obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.namespaceType() == null ^ this.namespaceType() == null) {
            return false;
        }
        if (other.namespaceType() != null && !other.namespaceType().equals(this.namespaceType())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.packaging() == null ^ this.packaging() == null) {
            return false;
        }
        return other.packaging() == null || other.packaging().equals(this.packaging());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.namespaceType() != null) {
            sb.append("NamespaceType: ").append(this.namespaceType()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.packaging() != null) {
            sb.append("Packaging: ").append(this.packaging()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectArtifactsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String type;
        private String location;
        private String path;
        private String namespaceType;
        private String name;
        private String packaging;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectArtifacts model) {
            this.setType(model.type);
            this.setLocation(model.location);
            this.setPath(model.path);
            this.setNamespaceType(model.namespaceType);
            this.setName(model.name);
            this.setPackaging(model.packaging);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ArtifactsType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getNamespaceType() {
            return this.namespaceType;
        }

        @Override
        public final Builder namespaceType(String namespaceType) {
            this.namespaceType = namespaceType;
            return this;
        }

        @Override
        public final Builder namespaceType(ArtifactNamespace namespaceType) {
            this.namespaceType(namespaceType.toString());
            return this;
        }

        public final void setNamespaceType(String namespaceType) {
            this.namespaceType = namespaceType;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPackaging() {
            return this.packaging;
        }

        @Override
        public final Builder packaging(String packaging) {
            this.packaging = packaging;
            return this;
        }

        @Override
        public final Builder packaging(ArtifactPackaging packaging) {
            this.packaging(packaging.toString());
            return this;
        }

        public final void setPackaging(String packaging) {
            this.packaging = packaging;
        }

        public ProjectArtifacts build() {
            return new ProjectArtifacts(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProjectArtifacts> {
        public Builder type(String var1);

        public Builder type(ArtifactsType var1);

        public Builder location(String var1);

        public Builder path(String var1);

        public Builder namespaceType(String var1);

        public Builder namespaceType(ArtifactNamespace var1);

        public Builder name(String var1);

        public Builder packaging(String var1);

        public Builder packaging(ArtifactPackaging var1);
    }
}

