/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codebuild.model.SortOrderType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListBuildsForProjectRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListBuildsForProjectRequest> {
    private final String projectName;
    private final String sortOrder;
    private final String nextToken;

    private ListBuildsForProjectRequest(BuilderImpl builder) {
        this.projectName = builder.projectName;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
    }

    public String projectName() {
        return this.projectName;
    }

    public String sortOrder() {
        return this.sortOrder;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.projectName() == null ? 0 : this.projectName().hashCode());
        hashCode = 31 * hashCode + (this.sortOrder() == null ? 0 : this.sortOrder().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuildsForProjectRequest)) {
            return false;
        }
        ListBuildsForProjectRequest other = (ListBuildsForProjectRequest)((Object)obj);
        if (other.projectName() == null ^ this.projectName() == null) {
            return false;
        }
        if (other.projectName() != null && !other.projectName().equals(this.projectName())) {
            return false;
        }
        if (other.sortOrder() == null ^ this.sortOrder() == null) {
            return false;
        }
        if (other.sortOrder() != null && !other.sortOrder().equals(this.sortOrder())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.projectName() != null) {
            sb.append("ProjectName: ").append(this.projectName()).append(",");
        }
        if (this.sortOrder() != null) {
            sb.append("SortOrder: ").append(this.sortOrder()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String projectName;
        private String sortOrder;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBuildsForProjectRequest model) {
            this.setProjectName(model.projectName);
            this.setSortOrder(model.sortOrder);
            this.setNextToken(model.nextToken);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrderType sortOrder) {
            this.sortOrder(sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListBuildsForProjectRequest build() {
            return new ListBuildsForProjectRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListBuildsForProjectRequest> {
        public Builder projectName(String var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrderType var1);

        public Builder nextToken(String var1);
    }
}

