/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codebuild.model.Build;
import software.amazon.awssdk.services.codebuild.transform.BuildArtifactsUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.BuildPhaseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.LogsLocationUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.ProjectEnvironmentUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.ProjectSourceUnmarshaller;

public class BuildUnmarshaller
implements Unmarshaller<Build, JsonUnmarshallerContext> {
    private static final BuildUnmarshaller INSTANCE = new BuildUnmarshaller();

    public Build unmarshall(JsonUnmarshallerContext context) throws Exception {
        Build.Builder buildBuilder = Build.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    buildBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    buildBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("startTime", targetDepth)) {
                    context.nextToken();
                    buildBuilder.startTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("endTime", targetDepth)) {
                    context.nextToken();
                    buildBuilder.endTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("currentPhase", targetDepth)) {
                    context.nextToken();
                    buildBuilder.currentPhase((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("buildStatus", targetDepth)) {
                    context.nextToken();
                    buildBuilder.buildStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("sourceVersion", targetDepth)) {
                    context.nextToken();
                    buildBuilder.sourceVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("projectName", targetDepth)) {
                    context.nextToken();
                    buildBuilder.projectName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("phases", targetDepth)) {
                    context.nextToken();
                    buildBuilder.phases(new ListUnmarshaller((Unmarshaller)BuildPhaseUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("source", targetDepth)) {
                    context.nextToken();
                    buildBuilder.source(ProjectSourceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("artifacts", targetDepth)) {
                    context.nextToken();
                    buildBuilder.artifacts(BuildArtifactsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("environment", targetDepth)) {
                    context.nextToken();
                    buildBuilder.environment(ProjectEnvironmentUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("logs", targetDepth)) {
                    context.nextToken();
                    buildBuilder.logs(LogsLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("timeoutInMinutes", targetDepth)) {
                    context.nextToken();
                    buildBuilder.timeoutInMinutes((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("buildComplete", targetDepth)) {
                    context.nextToken();
                    buildBuilder.buildComplete((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("initiator", targetDepth)) {
                    context.nextToken();
                    buildBuilder.initiator((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Build)buildBuilder.build();
    }

    public static BuildUnmarshaller getInstance() {
        return INSTANCE;
    }
}

