/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codebuild.model.ProjectSortByType;
import software.amazon.awssdk.services.codebuild.model.SortOrderType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListProjectsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListProjectsRequest> {
    private final String sortBy;
    private final String sortOrder;
    private final String nextToken;

    private ListProjectsRequest(BuilderImpl builder) {
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
    }

    public String sortBy() {
        return this.sortBy;
    }

    public String sortOrder() {
        return this.sortOrder;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sortBy() == null ? 0 : this.sortBy().hashCode());
        hashCode = 31 * hashCode + (this.sortOrder() == null ? 0 : this.sortOrder().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProjectsRequest)) {
            return false;
        }
        ListProjectsRequest other = (ListProjectsRequest)((Object)obj);
        if (other.sortBy() == null ^ this.sortBy() == null) {
            return false;
        }
        if (other.sortBy() != null && !other.sortBy().equals(this.sortBy())) {
            return false;
        }
        if (other.sortOrder() == null ^ this.sortOrder() == null) {
            return false;
        }
        if (other.sortOrder() != null && !other.sortOrder().equals(this.sortOrder())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sortBy() != null) {
            sb.append("SortBy: ").append(this.sortBy()).append(",");
        }
        if (this.sortOrder() != null) {
            sb.append("SortOrder: ").append(this.sortOrder()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String sortBy;
        private String sortOrder;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProjectsRequest model) {
            this.setSortBy(model.sortBy);
            this.setSortOrder(model.sortOrder);
            this.setNextToken(model.nextToken);
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ProjectSortByType sortBy) {
            this.sortBy(sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrderType sortOrder) {
            this.sortOrder(sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListProjectsRequest build() {
            return new ListProjectsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListProjectsRequest> {
        public Builder sortBy(String var1);

        public Builder sortBy(ProjectSortByType var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrderType var1);

        public Builder nextToken(String var1);
    }
}

