/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.transform.BuildArtifactsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BuildArtifacts
implements StructuredPojo,
ToCopyableBuilder<Builder, BuildArtifacts> {
    private final String location;
    private final String sha256sum;
    private final String md5sum;

    private BuildArtifacts(BuilderImpl builder) {
        this.location = builder.location;
        this.sha256sum = builder.sha256sum;
        this.md5sum = builder.md5sum;
    }

    public String location() {
        return this.location;
    }

    public String sha256sum() {
        return this.sha256sum;
    }

    public String md5sum() {
        return this.md5sum;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        hashCode = 31 * hashCode + (this.sha256sum() == null ? 0 : this.sha256sum().hashCode());
        hashCode = 31 * hashCode + (this.md5sum() == null ? 0 : this.md5sum().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildArtifacts)) {
            return false;
        }
        BuildArtifacts other = (BuildArtifacts)obj;
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.sha256sum() == null ^ this.sha256sum() == null) {
            return false;
        }
        if (other.sha256sum() != null && !other.sha256sum().equals(this.sha256sum())) {
            return false;
        }
        if (other.md5sum() == null ^ this.md5sum() == null) {
            return false;
        }
        return other.md5sum() == null || other.md5sum().equals(this.md5sum());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.sha256sum() != null) {
            sb.append("Sha256sum: ").append(this.sha256sum()).append(",");
        }
        if (this.md5sum() != null) {
            sb.append("Md5sum: ").append(this.md5sum()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuildArtifactsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String location;
        private String sha256sum;
        private String md5sum;

        private BuilderImpl() {
        }

        private BuilderImpl(BuildArtifacts model) {
            this.setLocation(model.location);
            this.setSha256sum(model.sha256sum);
            this.setMd5sum(model.md5sum);
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getSha256sum() {
            return this.sha256sum;
        }

        @Override
        public final Builder sha256sum(String sha256sum) {
            this.sha256sum = sha256sum;
            return this;
        }

        public final void setSha256sum(String sha256sum) {
            this.sha256sum = sha256sum;
        }

        public final String getMd5sum() {
            return this.md5sum;
        }

        @Override
        public final Builder md5sum(String md5sum) {
            this.md5sum = md5sum;
            return this;
        }

        public final void setMd5sum(String md5sum) {
            this.md5sum = md5sum;
        }

        public BuildArtifacts build() {
            return new BuildArtifacts(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BuildArtifacts> {
        public Builder location(String var1);

        public Builder sha256sum(String var1);

        public Builder md5sum(String var1);
    }
}

