/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.ComputeType;
import software.amazon.awssdk.services.codebuild.model.EnvironmentType;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariable;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.codebuild.transform.ProjectEnvironmentMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProjectEnvironment
implements StructuredPojo,
ToCopyableBuilder<Builder, ProjectEnvironment> {
    private final String type;
    private final String image;
    private final String computeType;
    private final List<EnvironmentVariable> environmentVariables;
    private final Boolean privilegedMode;

    private ProjectEnvironment(BuilderImpl builder) {
        this.type = builder.type;
        this.image = builder.image;
        this.computeType = builder.computeType;
        this.environmentVariables = builder.environmentVariables;
        this.privilegedMode = builder.privilegedMode;
    }

    public String type() {
        return this.type;
    }

    public String image() {
        return this.image;
    }

    public String computeType() {
        return this.computeType;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    public Boolean privilegedMode() {
        return this.privilegedMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.image() == null ? 0 : this.image().hashCode());
        hashCode = 31 * hashCode + (this.computeType() == null ? 0 : this.computeType().hashCode());
        hashCode = 31 * hashCode + (this.environmentVariables() == null ? 0 : this.environmentVariables().hashCode());
        hashCode = 31 * hashCode + (this.privilegedMode() == null ? 0 : this.privilegedMode().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectEnvironment)) {
            return false;
        }
        ProjectEnvironment other = (ProjectEnvironment)obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.image() == null ^ this.image() == null) {
            return false;
        }
        if (other.image() != null && !other.image().equals(this.image())) {
            return false;
        }
        if (other.computeType() == null ^ this.computeType() == null) {
            return false;
        }
        if (other.computeType() != null && !other.computeType().equals(this.computeType())) {
            return false;
        }
        if (other.environmentVariables() == null ^ this.environmentVariables() == null) {
            return false;
        }
        if (other.environmentVariables() != null && !other.environmentVariables().equals(this.environmentVariables())) {
            return false;
        }
        if (other.privilegedMode() == null ^ this.privilegedMode() == null) {
            return false;
        }
        return other.privilegedMode() == null || other.privilegedMode().equals(this.privilegedMode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.image() != null) {
            sb.append("Image: ").append(this.image()).append(",");
        }
        if (this.computeType() != null) {
            sb.append("ComputeType: ").append(this.computeType()).append(",");
        }
        if (this.environmentVariables() != null) {
            sb.append("EnvironmentVariables: ").append(this.environmentVariables()).append(",");
        }
        if (this.privilegedMode() != null) {
            sb.append("PrivilegedMode: ").append(this.privilegedMode()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectEnvironmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String type;
        private String image;
        private String computeType;
        private List<EnvironmentVariable> environmentVariables;
        private Boolean privilegedMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectEnvironment model) {
            this.setType(model.type);
            this.setImage(model.image);
            this.setComputeType(model.computeType);
            this.setEnvironmentVariables(model.environmentVariables);
            this.setPrivilegedMode(model.privilegedMode);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EnvironmentType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(EnvironmentType type) {
            this.type(type.toString());
        }

        public final String getImage() {
            return this.image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getComputeType() {
            return this.computeType;
        }

        @Override
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType(computeType.toString());
            return this;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        public final void setComputeType(ComputeType computeType) {
            this.computeType(computeType.toString());
        }

        public final Collection<EnvironmentVariable> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final Builder environmentVariables(Collection<EnvironmentVariable> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariables(EnvironmentVariable ... environmentVariables) {
            this.environmentVariables(Arrays.asList(environmentVariables));
            return this;
        }

        public final void setEnvironmentVariables(Collection<EnvironmentVariable> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        @SafeVarargs
        public final void setEnvironmentVariables(EnvironmentVariable ... environmentVariables) {
            this.environmentVariables(Arrays.asList(environmentVariables));
        }

        public final Boolean getPrivilegedMode() {
            return this.privilegedMode;
        }

        @Override
        public final Builder privilegedMode(Boolean privilegedMode) {
            this.privilegedMode = privilegedMode;
            return this;
        }

        public final void setPrivilegedMode(Boolean privilegedMode) {
            this.privilegedMode = privilegedMode;
        }

        public ProjectEnvironment build() {
            return new ProjectEnvironment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProjectEnvironment> {
        public Builder type(String var1);

        public Builder type(EnvironmentType var1);

        public Builder image(String var1);

        public Builder computeType(String var1);

        public Builder computeType(ComputeType var1);

        public Builder environmentVariables(Collection<EnvironmentVariable> var1);

        public Builder environmentVariables(EnvironmentVariable ... var1);

        public Builder privilegedMode(Boolean var1);
    }
}

