/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.ProjectBadge;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProjectBadgeMarshaller {
    private static final MarshallingInfo<Boolean> BADGEENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("badgeEnabled").isBinary(false).build();
    private static final MarshallingInfo<String> BADGEREQUESTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("badgeRequestUrl").isBinary(false).build();
    private static final ProjectBadgeMarshaller INSTANCE = new ProjectBadgeMarshaller();

    private ProjectBadgeMarshaller() {
    }

    public static ProjectBadgeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProjectBadge projectBadge, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)projectBadge, (String)"projectBadge");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)projectBadge.badgeEnabled(), BADGEENABLED_BINDING);
            protocolMarshaller.marshall((Object)projectBadge.badgeRequestUrl(), BADGEREQUESTURL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

