/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.NetworkInterface;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NetworkInterfaceMarshaller {
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subnetId").isBinary(false).build();
    private static final MarshallingInfo<String> NETWORKINTERFACEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkInterfaceId").isBinary(false).build();
    private static final NetworkInterfaceMarshaller INSTANCE = new NetworkInterfaceMarshaller();

    private NetworkInterfaceMarshaller() {
    }

    public static NetworkInterfaceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NetworkInterface networkInterface, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)networkInterface, (String)"networkInterface");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)networkInterface.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall((Object)networkInterface.networkInterfaceId(), NETWORKINTERFACEID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

