/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.Build;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BuildMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").isBinary(false).build();
    private static final MarshallingInfo<String> CURRENTPHASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentPhase").isBinary(false).build();
    private static final MarshallingInfo<String> BUILDSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buildStatus").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceVersion").isBinary(false).build();
    private static final MarshallingInfo<String> PROJECTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("projectName").isBinary(false).build();
    private static final MarshallingInfo<List> PHASES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("phases").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source").isBinary(false).build();
    private static final MarshallingInfo<List> SECONDARYSOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secondarySources").isBinary(false).build();
    private static final MarshallingInfo<List> SECONDARYSOURCEVERSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secondarySourceVersions").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("artifacts").isBinary(false).build();
    private static final MarshallingInfo<List> SECONDARYARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secondaryArtifacts").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CACHE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cache").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environment").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceRole").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LOGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logs").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMEOUTINMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeoutInMinutes").isBinary(false).build();
    private static final MarshallingInfo<Boolean> BUILDCOMPLETE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buildComplete").isBinary(false).build();
    private static final MarshallingInfo<String> INITIATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("initiator").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vpcConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NETWORKINTERFACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkInterface").isBinary(false).build();
    private static final MarshallingInfo<String> ENCRYPTIONKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionKey").isBinary(false).build();
    private static final BuildMarshaller INSTANCE = new BuildMarshaller();

    private BuildMarshaller() {
    }

    public static BuildMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Build build, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)build, (String)"build");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)build.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)build.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)build.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)build.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)build.currentPhase(), CURRENTPHASE_BINDING);
            protocolMarshaller.marshall((Object)build.buildStatusAsString(), BUILDSTATUS_BINDING);
            protocolMarshaller.marshall((Object)build.sourceVersion(), SOURCEVERSION_BINDING);
            protocolMarshaller.marshall((Object)build.projectName(), PROJECTNAME_BINDING);
            protocolMarshaller.marshall(build.phases(), PHASES_BINDING);
            protocolMarshaller.marshall((Object)build.source(), SOURCE_BINDING);
            protocolMarshaller.marshall(build.secondarySources(), SECONDARYSOURCES_BINDING);
            protocolMarshaller.marshall(build.secondarySourceVersions(), SECONDARYSOURCEVERSIONS_BINDING);
            protocolMarshaller.marshall((Object)build.artifacts(), ARTIFACTS_BINDING);
            protocolMarshaller.marshall(build.secondaryArtifacts(), SECONDARYARTIFACTS_BINDING);
            protocolMarshaller.marshall((Object)build.cache(), CACHE_BINDING);
            protocolMarshaller.marshall((Object)build.environment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall((Object)build.serviceRole(), SERVICEROLE_BINDING);
            protocolMarshaller.marshall((Object)build.logs(), LOGS_BINDING);
            protocolMarshaller.marshall((Object)build.timeoutInMinutes(), TIMEOUTINMINUTES_BINDING);
            protocolMarshaller.marshall((Object)build.buildComplete(), BUILDCOMPLETE_BINDING);
            protocolMarshaller.marshall((Object)build.initiator(), INITIATOR_BINDING);
            protocolMarshaller.marshall((Object)build.vpcConfig(), VPCCONFIG_BINDING);
            protocolMarshaller.marshall((Object)build.networkInterface(), NETWORKINTERFACE_BINDING);
            protocolMarshaller.marshall((Object)build.encryptionKey(), ENCRYPTIONKEY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

