/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.transform.ProjectSourceVersionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectSourceVersion
implements StructuredPojo,
ToCopyableBuilder<Builder, ProjectSourceVersion> {
    private final String sourceIdentifier;
    private final String sourceVersion;

    private ProjectSourceVersion(BuilderImpl builder) {
        this.sourceIdentifier = builder.sourceIdentifier;
        this.sourceVersion = builder.sourceVersion;
    }

    public String sourceIdentifier() {
        return this.sourceIdentifier;
    }

    public String sourceVersion() {
        return this.sourceVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectSourceVersion)) {
            return false;
        }
        ProjectSourceVersion other = (ProjectSourceVersion)obj;
        return Objects.equals(this.sourceIdentifier(), other.sourceIdentifier()) && Objects.equals(this.sourceVersion(), other.sourceVersion());
    }

    public String toString() {
        return ToString.builder((String)"ProjectSourceVersion").add("SourceIdentifier", (Object)this.sourceIdentifier()).add("SourceVersion", (Object)this.sourceVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceIdentifier()));
            }
            case "sourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectSourceVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceIdentifier;
        private String sourceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectSourceVersion model) {
            this.sourceIdentifier(model.sourceIdentifier);
            this.sourceVersion(model.sourceVersion);
        }

        public final String getSourceIdentifier() {
            return this.sourceIdentifier;
        }

        @Override
        public final Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public final void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        public ProjectSourceVersion build() {
            return new ProjectSourceVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProjectSourceVersion> {
        public Builder sourceIdentifier(String var1);

        public Builder sourceVersion(String var1);
    }
}

