/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.Project;
import software.amazon.awssdk.services.codebuild.model.ProjectNamesCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetProjectsResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, BatchGetProjectsResponse> {
    private final List<Project> projects;
    private final List<String> projectsNotFound;

    private BatchGetProjectsResponse(BuilderImpl builder) {
        super(builder);
        this.projects = builder.projects;
        this.projectsNotFound = builder.projectsNotFound;
    }

    public List<Project> projects() {
        return this.projects;
    }

    public List<String> projectsNotFound() {
        return this.projectsNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projects());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectsNotFound());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetProjectsResponse)) {
            return false;
        }
        BatchGetProjectsResponse other = (BatchGetProjectsResponse)((Object)obj);
        return Objects.equals(this.projects(), other.projects()) && Objects.equals(this.projectsNotFound(), other.projectsNotFound());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetProjectsResponse").add("Projects", this.projects()).add("ProjectsNotFound", this.projectsNotFound()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projects": {
                return Optional.ofNullable(clazz.cast(this.projects()));
            }
            case "projectsNotFound": {
                return Optional.ofNullable(clazz.cast(this.projectsNotFound()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private List<Project> projects = DefaultSdkAutoConstructList.getInstance();
        private List<String> projectsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetProjectsResponse model) {
            super(model);
            this.projects(model.projects);
            this.projectsNotFound(model.projectsNotFound);
        }

        public final Collection<Project.Builder> getProjects() {
            return this.projects != null ? (Collection)this.projects.stream().map(Project::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder projects(Collection<Project> projects) {
            this.projects = ProjectsCopier.copy(projects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(Project ... projects) {
            this.projects(Arrays.asList(projects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(Consumer<Project.Builder> ... projects) {
            this.projects(Stream.of(projects).map(c -> (Project)((Project.Builder)Project.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProjects(Collection<Project.BuilderImpl> projects) {
            this.projects = ProjectsCopier.copyFromBuilder(projects);
        }

        public final Collection<String> getProjectsNotFound() {
            return this.projectsNotFound;
        }

        @Override
        public final Builder projectsNotFound(Collection<String> projectsNotFound) {
            this.projectsNotFound = ProjectNamesCopier.copy(projectsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectsNotFound(String ... projectsNotFound) {
            this.projectsNotFound(Arrays.asList(projectsNotFound));
            return this;
        }

        public final void setProjectsNotFound(Collection<String> projectsNotFound) {
            this.projectsNotFound = ProjectNamesCopier.copy(projectsNotFound);
        }

        @Override
        public BatchGetProjectsResponse build() {
            return new BatchGetProjectsResponse(this);
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    CopyableBuilder<Builder, BatchGetProjectsResponse> {
        public Builder projects(Collection<Project> var1);

        public Builder projects(Project ... var1);

        public Builder projects(Consumer<Project.Builder> ... var1);

        public Builder projectsNotFound(Collection<String> var1);

        public Builder projectsNotFound(String ... var1);
    }
}

