/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.model.AccountLimitExceededException;
import software.amazon.awssdk.services.codebuild.model.BatchDeleteBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchDeleteBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse;
import software.amazon.awssdk.services.codebuild.model.CodeBuildException;
import software.amazon.awssdk.services.codebuild.model.CreateProjectRequest;
import software.amazon.awssdk.services.codebuild.model.CreateProjectResponse;
import software.amazon.awssdk.services.codebuild.model.CreateWebhookRequest;
import software.amazon.awssdk.services.codebuild.model.CreateWebhookResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteProjectRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteProjectResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteWebhookRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteWebhookResponse;
import software.amazon.awssdk.services.codebuild.model.InvalidInputException;
import software.amazon.awssdk.services.codebuild.model.InvalidateProjectCacheRequest;
import software.amazon.awssdk.services.codebuild.model.InvalidateProjectCacheResponse;
import software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectResponse;
import software.amazon.awssdk.services.codebuild.model.ListBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesRequest;
import software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesResponse;
import software.amazon.awssdk.services.codebuild.model.ListProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.ListProjectsResponse;
import software.amazon.awssdk.services.codebuild.model.OAuthProviderException;
import software.amazon.awssdk.services.codebuild.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.codebuild.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codebuild.model.StartBuildRequest;
import software.amazon.awssdk.services.codebuild.model.StartBuildResponse;
import software.amazon.awssdk.services.codebuild.model.StopBuildRequest;
import software.amazon.awssdk.services.codebuild.model.StopBuildResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateWebhookRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateWebhookResponse;
import software.amazon.awssdk.services.codebuild.transform.BatchDeleteBuildsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchDeleteBuildsResponseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetBuildsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetBuildsResponseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetProjectsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetProjectsResponseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.CreateProjectResponseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.CreateWebhookRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.CreateWebhookResponseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteProjectRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteProjectResponseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteWebhookRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteWebhookResponseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.InvalidateProjectCacheRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.InvalidateProjectCacheResponseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListBuildsForProjectRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListBuildsForProjectResponseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListBuildsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListBuildsResponseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListCuratedEnvironmentImagesRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListCuratedEnvironmentImagesResponseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListProjectsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListProjectsResponseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.StartBuildRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StartBuildResponseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.StopBuildRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StopBuildResponseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.UpdateProjectRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.UpdateProjectResponseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.UpdateWebhookRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.UpdateWebhookResponseUnmarshaller;

@SdkInternalApi
final class DefaultCodeBuildClient
implements CodeBuildClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeBuildClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "codebuild";
    }

    @Override
    public BatchDeleteBuildsResponse batchDeleteBuilds(BatchDeleteBuildsRequest batchDeleteBuildsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDeleteBuildsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (BatchDeleteBuildsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDeleteBuildsRequest).withMarshaller((Marshaller)new BatchDeleteBuildsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public BatchGetBuildsResponse batchGetBuilds(BatchGetBuildsRequest batchGetBuildsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetBuildsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (BatchGetBuildsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetBuildsRequest).withMarshaller((Marshaller)new BatchGetBuildsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public BatchGetProjectsResponse batchGetProjects(BatchGetProjectsRequest batchGetProjectsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetProjectsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (BatchGetProjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetProjectsRequest).withMarshaller((Marshaller)new BatchGetProjectsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws InvalidInputException, ResourceAlreadyExistsException, AccountLimitExceededException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateProjectResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createProjectRequest).withMarshaller((Marshaller)new CreateProjectRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateWebhookResponse createWebhook(CreateWebhookRequest createWebhookRequest) throws InvalidInputException, OAuthProviderException, ResourceAlreadyExistsException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateWebhookResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWebhookRequest).withMarshaller((Marshaller)new CreateWebhookRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteProjectResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteProjectRequest).withMarshaller((Marshaller)new DeleteProjectRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteWebhookResponse deleteWebhook(DeleteWebhookRequest deleteWebhookRequest) throws InvalidInputException, ResourceNotFoundException, OAuthProviderException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteWebhookResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWebhookRequest).withMarshaller((Marshaller)new DeleteWebhookRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public InvalidateProjectCacheResponse invalidateProjectCache(InvalidateProjectCacheRequest invalidateProjectCacheRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InvalidateProjectCacheResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (InvalidateProjectCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)invalidateProjectCacheRequest).withMarshaller((Marshaller)new InvalidateProjectCacheRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListBuildsResponse listBuilds(ListBuildsRequest listBuildsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListBuildsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListBuildsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBuildsRequest).withMarshaller((Marshaller)new ListBuildsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListBuildsForProjectResponse listBuildsForProject(ListBuildsForProjectRequest listBuildsForProjectRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListBuildsForProjectResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListBuildsForProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBuildsForProjectRequest).withMarshaller((Marshaller)new ListBuildsForProjectRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListCuratedEnvironmentImagesResponse listCuratedEnvironmentImages(ListCuratedEnvironmentImagesRequest listCuratedEnvironmentImagesRequest) throws AwsServiceException, SdkClientException, CodeBuildException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCuratedEnvironmentImagesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListCuratedEnvironmentImagesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCuratedEnvironmentImagesRequest).withMarshaller((Marshaller)new ListCuratedEnvironmentImagesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProjectsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListProjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listProjectsRequest).withMarshaller((Marshaller)new ListProjectsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartBuildResponse startBuild(StartBuildRequest startBuildRequest) throws InvalidInputException, ResourceNotFoundException, AccountLimitExceededException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartBuildResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StartBuildResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startBuildRequest).withMarshaller((Marshaller)new StartBuildRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StopBuildResponse stopBuild(StopBuildRequest stopBuildRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopBuildResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StopBuildResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopBuildRequest).withMarshaller((Marshaller)new StopBuildRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest updateProjectRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateProjectResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateProjectRequest).withMarshaller((Marshaller)new UpdateProjectRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateWebhookResponse updateWebhook(UpdateWebhookRequest updateWebhookRequest) throws InvalidInputException, ResourceNotFoundException, OAuthProviderException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateWebhookResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateWebhookRequest).withMarshaller((Marshaller)new UpdateWebhookRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(CodeBuildException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withModeledClass(InvalidInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccountLimitExceededException").withModeledClass(AccountLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OAuthProviderException").withModeledClass(OAuthProviderException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

