/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.SourceAuth;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SourceAuthMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resource").isBinary(false).build();
    private static final SourceAuthMarshaller INSTANCE = new SourceAuthMarshaller();

    private SourceAuthMarshaller() {
    }

    public static SourceAuthMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SourceAuth sourceAuth, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sourceAuth, (String)"sourceAuth");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sourceAuth.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)sourceAuth.resource(), RESOURCE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

