/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.EnvironmentImage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EnvironmentImageMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final EnvironmentImageMarshaller INSTANCE = new EnvironmentImageMarshaller();

    private EnvironmentImageMarshaller() {
    }

    public static EnvironmentImageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EnvironmentImage environmentImage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)environmentImage, (String)"environmentImage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)environmentImage.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)environmentImage.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

