/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.SourceAuth;
import software.amazon.awssdk.services.codebuild.model.SourceType;
import software.amazon.awssdk.services.codebuild.transform.ProjectSourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProjectSource
implements StructuredPojo,
ToCopyableBuilder<Builder, ProjectSource> {
    private final String type;
    private final String location;
    private final String buildspec;
    private final SourceAuth auth;

    private ProjectSource(BuilderImpl builder) {
        this.type = builder.type;
        this.location = builder.location;
        this.buildspec = builder.buildspec;
        this.auth = builder.auth;
    }

    public SourceType type() {
        return SourceType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String location() {
        return this.location;
    }

    public String buildspec() {
        return this.buildspec;
    }

    public SourceAuth auth() {
        return this.auth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildspec());
        hashCode = 31 * hashCode + Objects.hashCode(this.auth());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectSource)) {
            return false;
        }
        ProjectSource other = (ProjectSource)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.buildspec(), other.buildspec()) && Objects.equals(this.auth(), other.auth());
    }

    public String toString() {
        return ToString.builder((String)"ProjectSource").add("Type", (Object)this.typeAsString()).add("Location", (Object)this.location()).add("Buildspec", (Object)this.buildspec()).add("Auth", (Object)this.auth()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "buildspec": {
                return Optional.of(clazz.cast(this.buildspec()));
            }
            case "auth": {
                return Optional.of(clazz.cast(this.auth()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String location;
        private String buildspec;
        private SourceAuth auth;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectSource model) {
            this.type(model.type);
            this.location(model.location);
            this.buildspec(model.buildspec);
            this.auth(model.auth);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getBuildspec() {
            return this.buildspec;
        }

        @Override
        public final Builder buildspec(String buildspec) {
            this.buildspec = buildspec;
            return this;
        }

        public final void setBuildspec(String buildspec) {
            this.buildspec = buildspec;
        }

        public final SourceAuth.Builder getAuth() {
            return this.auth != null ? this.auth.toBuilder() : null;
        }

        @Override
        public final Builder auth(SourceAuth auth) {
            this.auth = auth;
            return this;
        }

        public final void setAuth(SourceAuth.BuilderImpl auth) {
            this.auth = auth != null ? auth.build() : null;
        }

        public ProjectSource build() {
            return new ProjectSource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProjectSource> {
        public Builder type(String var1);

        public Builder type(SourceType var1);

        public Builder location(String var1);

        public Builder buildspec(String var1);

        public Builder auth(SourceAuth var1);

        default public Builder auth(Consumer<SourceAuth.Builder> auth) {
            return this.auth((SourceAuth)((SourceAuth.Builder)SourceAuth.builder().apply(auth)).build());
        }
    }
}

