/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariableType;
import software.amazon.awssdk.services.codebuild.transform.EnvironmentVariableMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnvironmentVariable
implements StructuredPojo,
ToCopyableBuilder<Builder, EnvironmentVariable> {
    private final String name;
    private final String value;
    private final String type;

    private EnvironmentVariable(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.type = builder.type;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public EnvironmentVariableType type() {
        return EnvironmentVariableType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentVariable)) {
            return false;
        }
        EnvironmentVariable other = (EnvironmentVariable)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"EnvironmentVariable").add("Name", (Object)this.name()).add("Value", (Object)this.value()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentVariableMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String value;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentVariable model) {
            this.name(model.name);
            this.value(model.value);
            this.type(model.type);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EnvironmentVariableType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public EnvironmentVariable build() {
            return new EnvironmentVariable(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentVariable> {
        public Builder name(String var1);

        public Builder value(String var1);

        public Builder type(String var1);

        public Builder type(EnvironmentVariableType var1);
    }
}

