/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupSummary;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSubPackageGroupsResponse
extends CodeartifactResponse
implements ToCopyableBuilder<Builder, ListSubPackageGroupsResponse> {
    private static final SdkField<List<PackageGroupSummary>> PACKAGE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("packageGroups").getter(ListSubPackageGroupsResponse.getter(ListSubPackageGroupsResponse::packageGroups)).setter(ListSubPackageGroupsResponse.setter(Builder::packageGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PackageGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSubPackageGroupsResponse.getter(ListSubPackageGroupsResponse::nextToken)).setter(ListSubPackageGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSubPackageGroupsResponse.memberNameToFieldInitializer();
    private final List<PackageGroupSummary> packageGroups;
    private final String nextToken;

    private ListSubPackageGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.packageGroups = builder.packageGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPackageGroups() {
        return this.packageGroups != null && !(this.packageGroups instanceof SdkAutoConstructList);
    }

    public final List<PackageGroupSummary> packageGroups() {
        return this.packageGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPackageGroups() ? this.packageGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubPackageGroupsResponse)) {
            return false;
        }
        ListSubPackageGroupsResponse other = (ListSubPackageGroupsResponse)((Object)obj);
        return this.hasPackageGroups() == other.hasPackageGroups() && Objects.equals(this.packageGroups(), other.packageGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSubPackageGroupsResponse").add("PackageGroups", this.hasPackageGroups() ? this.packageGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packageGroups": {
                return Optional.ofNullable(clazz.cast(this.packageGroups()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("packageGroups", PACKAGE_GROUPS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSubPackageGroupsResponse, T> g) {
        return obj -> g.apply((ListSubPackageGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactResponse.BuilderImpl
    implements Builder {
        private List<PackageGroupSummary> packageGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubPackageGroupsResponse model) {
            super(model);
            this.packageGroups(model.packageGroups);
            this.nextToken(model.nextToken);
        }

        public final List<PackageGroupSummary.Builder> getPackageGroups() {
            List<PackageGroupSummary.Builder> result = PackageGroupSummaryListCopier.copyToBuilder(this.packageGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPackageGroups(Collection<PackageGroupSummary.BuilderImpl> packageGroups) {
            this.packageGroups = PackageGroupSummaryListCopier.copyFromBuilder(packageGroups);
        }

        @Override
        public final Builder packageGroups(Collection<PackageGroupSummary> packageGroups) {
            this.packageGroups = PackageGroupSummaryListCopier.copy(packageGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageGroups(PackageGroupSummary ... packageGroups) {
            this.packageGroups(Arrays.asList(packageGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageGroups(Consumer<PackageGroupSummary.Builder> ... packageGroups) {
            this.packageGroups(Stream.of(packageGroups).map(c -> (PackageGroupSummary)((PackageGroupSummary.Builder)PackageGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSubPackageGroupsResponse build() {
            return new ListSubPackageGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeartifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSubPackageGroupsResponse> {
        public Builder packageGroups(Collection<PackageGroupSummary> var1);

        public Builder packageGroups(PackageGroupSummary ... var1);

        public Builder packageGroups(Consumer<PackageGroupSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

