/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactAsyncClient;
import software.amazon.awssdk.services.codeartifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeartifact.model.ListSubPackageGroupsRequest;
import software.amazon.awssdk.services.codeartifact.model.ListSubPackageGroupsResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupSummary;

public class ListSubPackageGroupsPublisher
implements SdkPublisher<ListSubPackageGroupsResponse> {
    private final CodeartifactAsyncClient client;
    private final ListSubPackageGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSubPackageGroupsPublisher(CodeartifactAsyncClient client, ListSubPackageGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSubPackageGroupsPublisher(CodeartifactAsyncClient client, ListSubPackageGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSubPackageGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSubPackageGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PackageGroupSummary> packageGroups() {
        Function<ListSubPackageGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.packageGroups() != null) {
                return response.packageGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSubPackageGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSubPackageGroupsResponseFetcher
    implements AsyncPageFetcher<ListSubPackageGroupsResponse> {
        private ListSubPackageGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubPackageGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSubPackageGroupsResponse> nextPage(ListSubPackageGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListSubPackageGroupsPublisher.this.client.listSubPackageGroups(ListSubPackageGroupsPublisher.this.firstRequest);
            }
            return ListSubPackageGroupsPublisher.this.client.listSubPackageGroups((ListSubPackageGroupsRequest)((Object)ListSubPackageGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

