/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeartifact.model.RepositoryExternalConnectionInfo;
import software.amazon.awssdk.services.codeartifact.model.RepositoryExternalConnectionInfoListCopier;
import software.amazon.awssdk.services.codeartifact.model.UpstreamRepositoryInfo;
import software.amazon.awssdk.services.codeartifact.model.UpstreamRepositoryInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepositoryDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepositoryDescription> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RepositoryDescription.getter(RepositoryDescription::name)).setter(RepositoryDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ADMINISTRATOR_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("administratorAccount").getter(RepositoryDescription.getter(RepositoryDescription::administratorAccount)).setter(RepositoryDescription.setter(Builder::administratorAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("administratorAccount").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(RepositoryDescription.getter(RepositoryDescription::domainName)).setter(RepositoryDescription.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainOwner").getter(RepositoryDescription.getter(RepositoryDescription::domainOwner)).setter(RepositoryDescription.setter(Builder::domainOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainOwner").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(RepositoryDescription.getter(RepositoryDescription::arn)).setter(RepositoryDescription.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(RepositoryDescription.getter(RepositoryDescription::description)).setter(RepositoryDescription.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<UpstreamRepositoryInfo>> UPSTREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("upstreams").getter(RepositoryDescription.getter(RepositoryDescription::upstreams)).setter(RepositoryDescription.setter(Builder::upstreams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpstreamRepositoryInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RepositoryExternalConnectionInfo>> EXTERNAL_CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("externalConnections").getter(RepositoryDescription.getter(RepositoryDescription::externalConnections)).setter(RepositoryDescription.setter(Builder::externalConnections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalConnections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RepositoryExternalConnectionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(RepositoryDescription.getter(RepositoryDescription::createdTime)).setter(RepositoryDescription.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ADMINISTRATOR_ACCOUNT_FIELD, DOMAIN_NAME_FIELD, DOMAIN_OWNER_FIELD, ARN_FIELD, DESCRIPTION_FIELD, UPSTREAMS_FIELD, EXTERNAL_CONNECTIONS_FIELD, CREATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RepositoryDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String administratorAccount;
    private final String domainName;
    private final String domainOwner;
    private final String arn;
    private final String description;
    private final List<UpstreamRepositoryInfo> upstreams;
    private final List<RepositoryExternalConnectionInfo> externalConnections;
    private final Instant createdTime;

    private RepositoryDescription(BuilderImpl builder) {
        this.name = builder.name;
        this.administratorAccount = builder.administratorAccount;
        this.domainName = builder.domainName;
        this.domainOwner = builder.domainOwner;
        this.arn = builder.arn;
        this.description = builder.description;
        this.upstreams = builder.upstreams;
        this.externalConnections = builder.externalConnections;
        this.createdTime = builder.createdTime;
    }

    public final String name() {
        return this.name;
    }

    public final String administratorAccount() {
        return this.administratorAccount;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String domainOwner() {
        return this.domainOwner;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasUpstreams() {
        return this.upstreams != null && !(this.upstreams instanceof SdkAutoConstructList);
    }

    public final List<UpstreamRepositoryInfo> upstreams() {
        return this.upstreams;
    }

    public final boolean hasExternalConnections() {
        return this.externalConnections != null && !(this.externalConnections instanceof SdkAutoConstructList);
    }

    public final List<RepositoryExternalConnectionInfo> externalConnections() {
        return this.externalConnections;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.administratorAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpstreams() ? this.upstreams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExternalConnections() ? this.externalConnections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryDescription)) {
            return false;
        }
        RepositoryDescription other = (RepositoryDescription)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.administratorAccount(), other.administratorAccount()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.domainOwner(), other.domainOwner()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && this.hasUpstreams() == other.hasUpstreams() && Objects.equals(this.upstreams(), other.upstreams()) && this.hasExternalConnections() == other.hasExternalConnections() && Objects.equals(this.externalConnections(), other.externalConnections()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public final String toString() {
        return ToString.builder((String)"RepositoryDescription").add("Name", (Object)this.name()).add("AdministratorAccount", (Object)this.administratorAccount()).add("DomainName", (Object)this.domainName()).add("DomainOwner", (Object)this.domainOwner()).add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("Upstreams", this.hasUpstreams() ? this.upstreams() : null).add("ExternalConnections", this.hasExternalConnections() ? this.externalConnections() : null).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "administratorAccount": {
                return Optional.ofNullable(clazz.cast(this.administratorAccount()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "domainOwner": {
                return Optional.ofNullable(clazz.cast(this.domainOwner()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "upstreams": {
                return Optional.ofNullable(clazz.cast(this.upstreams()));
            }
            case "externalConnections": {
                return Optional.ofNullable(clazz.cast(this.externalConnections()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("administratorAccount", ADMINISTRATOR_ACCOUNT_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("domainOwner", DOMAIN_OWNER_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("upstreams", UPSTREAMS_FIELD);
        map.put("externalConnections", EXTERNAL_CONNECTIONS_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RepositoryDescription, T> g) {
        return obj -> g.apply((RepositoryDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String administratorAccount;
        private String domainName;
        private String domainOwner;
        private String arn;
        private String description;
        private List<UpstreamRepositoryInfo> upstreams = DefaultSdkAutoConstructList.getInstance();
        private List<RepositoryExternalConnectionInfo> externalConnections = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryDescription model) {
            this.name(model.name);
            this.administratorAccount(model.administratorAccount);
            this.domainName(model.domainName);
            this.domainOwner(model.domainOwner);
            this.arn(model.arn);
            this.description(model.description);
            this.upstreams(model.upstreams);
            this.externalConnections(model.externalConnections);
            this.createdTime(model.createdTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAdministratorAccount() {
            return this.administratorAccount;
        }

        public final void setAdministratorAccount(String administratorAccount) {
            this.administratorAccount = administratorAccount;
        }

        @Override
        public final Builder administratorAccount(String administratorAccount) {
            this.administratorAccount = administratorAccount;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDomainOwner() {
            return this.domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<UpstreamRepositoryInfo.Builder> getUpstreams() {
            List<UpstreamRepositoryInfo.Builder> result = UpstreamRepositoryInfoListCopier.copyToBuilder(this.upstreams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpstreams(Collection<UpstreamRepositoryInfo.BuilderImpl> upstreams) {
            this.upstreams = UpstreamRepositoryInfoListCopier.copyFromBuilder(upstreams);
        }

        @Override
        public final Builder upstreams(Collection<UpstreamRepositoryInfo> upstreams) {
            this.upstreams = UpstreamRepositoryInfoListCopier.copy(upstreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upstreams(UpstreamRepositoryInfo ... upstreams) {
            this.upstreams(Arrays.asList(upstreams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upstreams(Consumer<UpstreamRepositoryInfo.Builder> ... upstreams) {
            this.upstreams(Stream.of(upstreams).map(c -> (UpstreamRepositoryInfo)((UpstreamRepositoryInfo.Builder)UpstreamRepositoryInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RepositoryExternalConnectionInfo.Builder> getExternalConnections() {
            List<RepositoryExternalConnectionInfo.Builder> result = RepositoryExternalConnectionInfoListCopier.copyToBuilder(this.externalConnections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExternalConnections(Collection<RepositoryExternalConnectionInfo.BuilderImpl> externalConnections) {
            this.externalConnections = RepositoryExternalConnectionInfoListCopier.copyFromBuilder(externalConnections);
        }

        @Override
        public final Builder externalConnections(Collection<RepositoryExternalConnectionInfo> externalConnections) {
            this.externalConnections = RepositoryExternalConnectionInfoListCopier.copy(externalConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalConnections(RepositoryExternalConnectionInfo ... externalConnections) {
            this.externalConnections(Arrays.asList(externalConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalConnections(Consumer<RepositoryExternalConnectionInfo.Builder> ... externalConnections) {
            this.externalConnections(Stream.of(externalConnections).map(c -> (RepositoryExternalConnectionInfo)((RepositoryExternalConnectionInfo.Builder)RepositoryExternalConnectionInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public RepositoryDescription build() {
            return new RepositoryDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepositoryDescription> {
        public Builder name(String var1);

        public Builder administratorAccount(String var1);

        public Builder domainName(String var1);

        public Builder domainOwner(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder upstreams(Collection<UpstreamRepositoryInfo> var1);

        public Builder upstreams(UpstreamRepositoryInfo ... var1);

        public Builder upstreams(Consumer<UpstreamRepositoryInfo.Builder> ... var1);

        public Builder externalConnections(Collection<RepositoryExternalConnectionInfo> var1);

        public Builder externalConnections(RepositoryExternalConnectionInfo ... var1);

        public Builder externalConnections(Consumer<RepositoryExternalConnectionInfo.Builder> ... var1);

        public Builder createdTime(Instant var1);
    }
}

