/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupOriginConfiguration;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageGroupDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageGroupDescription> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(PackageGroupDescription.getter(PackageGroupDescription::arn)).setter(PackageGroupDescription.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pattern").getter(PackageGroupDescription.getter(PackageGroupDescription::pattern)).setter(PackageGroupDescription.setter(Builder::pattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pattern").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(PackageGroupDescription.getter(PackageGroupDescription::domainName)).setter(PackageGroupDescription.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainOwner").getter(PackageGroupDescription.getter(PackageGroupDescription::domainOwner)).setter(PackageGroupDescription.setter(Builder::domainOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainOwner").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(PackageGroupDescription.getter(PackageGroupDescription::createdTime)).setter(PackageGroupDescription.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<String> CONTACT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contactInfo").getter(PackageGroupDescription.getter(PackageGroupDescription::contactInfo)).setter(PackageGroupDescription.setter(Builder::contactInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactInfo").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(PackageGroupDescription.getter(PackageGroupDescription::description)).setter(PackageGroupDescription.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<PackageGroupOriginConfiguration> ORIGIN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("originConfiguration").getter(PackageGroupDescription.getter(PackageGroupDescription::originConfiguration)).setter(PackageGroupDescription.setter(Builder::originConfiguration)).constructor(PackageGroupOriginConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originConfiguration").build()}).build();
    private static final SdkField<PackageGroupReference> PARENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parent").getter(PackageGroupDescription.getter(PackageGroupDescription::parent)).setter(PackageGroupDescription.setter(Builder::parent)).constructor(PackageGroupReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PATTERN_FIELD, DOMAIN_NAME_FIELD, DOMAIN_OWNER_FIELD, CREATED_TIME_FIELD, CONTACT_INFO_FIELD, DESCRIPTION_FIELD, ORIGIN_CONFIGURATION_FIELD, PARENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("pattern", PATTERN_FIELD);
            this.put("domainName", DOMAIN_NAME_FIELD);
            this.put("domainOwner", DOMAIN_OWNER_FIELD);
            this.put("createdTime", CREATED_TIME_FIELD);
            this.put("contactInfo", CONTACT_INFO_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("originConfiguration", ORIGIN_CONFIGURATION_FIELD);
            this.put("parent", PARENT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String pattern;
    private final String domainName;
    private final String domainOwner;
    private final Instant createdTime;
    private final String contactInfo;
    private final String description;
    private final PackageGroupOriginConfiguration originConfiguration;
    private final PackageGroupReference parent;

    private PackageGroupDescription(BuilderImpl builder) {
        this.arn = builder.arn;
        this.pattern = builder.pattern;
        this.domainName = builder.domainName;
        this.domainOwner = builder.domainOwner;
        this.createdTime = builder.createdTime;
        this.contactInfo = builder.contactInfo;
        this.description = builder.description;
        this.originConfiguration = builder.originConfiguration;
        this.parent = builder.parent;
    }

    public final String arn() {
        return this.arn;
    }

    public final String pattern() {
        return this.pattern;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String domainOwner() {
        return this.domainOwner;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String contactInfo() {
        return this.contactInfo;
    }

    public final String description() {
        return this.description;
    }

    public final PackageGroupOriginConfiguration originConfiguration() {
        return this.originConfiguration;
    }

    public final PackageGroupReference parent() {
        return this.parent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.originConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.parent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageGroupDescription)) {
            return false;
        }
        PackageGroupDescription other = (PackageGroupDescription)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.pattern(), other.pattern()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.domainOwner(), other.domainOwner()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.contactInfo(), other.contactInfo()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.originConfiguration(), other.originConfiguration()) && Objects.equals(this.parent(), other.parent());
    }

    public final String toString() {
        return ToString.builder((String)"PackageGroupDescription").add("Arn", (Object)this.arn()).add("Pattern", (Object)this.pattern()).add("DomainName", (Object)this.domainName()).add("DomainOwner", (Object)this.domainOwner()).add("CreatedTime", (Object)this.createdTime()).add("ContactInfo", (Object)this.contactInfo()).add("Description", (Object)this.description()).add("OriginConfiguration", (Object)this.originConfiguration()).add("Parent", (Object)this.parent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "pattern": {
                return Optional.ofNullable(clazz.cast(this.pattern()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "domainOwner": {
                return Optional.ofNullable(clazz.cast(this.domainOwner()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "contactInfo": {
                return Optional.ofNullable(clazz.cast(this.contactInfo()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "originConfiguration": {
                return Optional.ofNullable(clazz.cast(this.originConfiguration()));
            }
            case "parent": {
                return Optional.ofNullable(clazz.cast(this.parent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PackageGroupDescription, T> g) {
        return obj -> g.apply((PackageGroupDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String pattern;
        private String domainName;
        private String domainOwner;
        private Instant createdTime;
        private String contactInfo;
        private String description;
        private PackageGroupOriginConfiguration originConfiguration;
        private PackageGroupReference parent;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageGroupDescription model) {
            this.arn(model.arn);
            this.pattern(model.pattern);
            this.domainName(model.domainName);
            this.domainOwner(model.domainOwner);
            this.createdTime(model.createdTime);
            this.contactInfo(model.contactInfo);
            this.description(model.description);
            this.originConfiguration(model.originConfiguration);
            this.parent(model.parent);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPattern() {
            return this.pattern;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDomainOwner() {
            return this.domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getContactInfo() {
            return this.contactInfo;
        }

        public final void setContactInfo(String contactInfo) {
            this.contactInfo = contactInfo;
        }

        @Override
        public final Builder contactInfo(String contactInfo) {
            this.contactInfo = contactInfo;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final PackageGroupOriginConfiguration.Builder getOriginConfiguration() {
            return this.originConfiguration != null ? this.originConfiguration.toBuilder() : null;
        }

        public final void setOriginConfiguration(PackageGroupOriginConfiguration.BuilderImpl originConfiguration) {
            this.originConfiguration = originConfiguration != null ? originConfiguration.build() : null;
        }

        @Override
        public final Builder originConfiguration(PackageGroupOriginConfiguration originConfiguration) {
            this.originConfiguration = originConfiguration;
            return this;
        }

        public final PackageGroupReference.Builder getParent() {
            return this.parent != null ? this.parent.toBuilder() : null;
        }

        public final void setParent(PackageGroupReference.BuilderImpl parent) {
            this.parent = parent != null ? parent.build() : null;
        }

        @Override
        public final Builder parent(PackageGroupReference parent) {
            this.parent = parent;
            return this;
        }

        public PackageGroupDescription build() {
            return new PackageGroupDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageGroupDescription> {
        public Builder arn(String var1);

        public Builder pattern(String var1);

        public Builder domainName(String var1);

        public Builder domainOwner(String var1);

        public Builder createdTime(Instant var1);

        public Builder contactInfo(String var1);

        public Builder description(String var1);

        public Builder originConfiguration(PackageGroupOriginConfiguration var1);

        default public Builder originConfiguration(Consumer<PackageGroupOriginConfiguration.Builder> originConfiguration) {
            return this.originConfiguration((PackageGroupOriginConfiguration)((PackageGroupOriginConfiguration.Builder)PackageGroupOriginConfiguration.builder().applyMutation(originConfiguration)).build());
        }

        public Builder parent(PackageGroupReference var1);

        default public Builder parent(Consumer<PackageGroupReference.Builder> parent) {
            return this.parent((PackageGroupReference)((PackageGroupReference.Builder)PackageGroupReference.builder().applyMutation(parent)).build());
        }
    }
}

