/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupAllowedRepositoryUpdateType;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupAllowedRepositoryUpdatesCopier;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupDescription;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupOriginRestrictionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePackageGroupOriginConfigurationResponse
extends CodeartifactResponse
implements ToCopyableBuilder<Builder, UpdatePackageGroupOriginConfigurationResponse> {
    private static final SdkField<PackageGroupDescription> PACKAGE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("packageGroup").getter(UpdatePackageGroupOriginConfigurationResponse.getter(UpdatePackageGroupOriginConfigurationResponse::packageGroup)).setter(UpdatePackageGroupOriginConfigurationResponse.setter(Builder::packageGroup)).constructor(PackageGroupDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageGroup").build()}).build();
    private static final SdkField<Map<String, Map<String, List<String>>>> ALLOWED_REPOSITORY_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("allowedRepositoryUpdates").getter(UpdatePackageGroupOriginConfigurationResponse.getter(UpdatePackageGroupOriginConfigurationResponse::allowedRepositoryUpdatesAsStrings)).setter(UpdatePackageGroupOriginConfigurationResponse.setter(Builder::allowedRepositoryUpdatesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedRepositoryUpdates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_GROUP_FIELD, ALLOWED_REPOSITORY_UPDATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("packageGroup", PACKAGE_GROUP_FIELD);
            this.put("allowedRepositoryUpdates", ALLOWED_REPOSITORY_UPDATES_FIELD);
        }
    });
    private final PackageGroupDescription packageGroup;
    private final Map<String, Map<String, List<String>>> allowedRepositoryUpdates;

    private UpdatePackageGroupOriginConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.packageGroup = builder.packageGroup;
        this.allowedRepositoryUpdates = builder.allowedRepositoryUpdates;
    }

    public final PackageGroupDescription packageGroup() {
        return this.packageGroup;
    }

    public final Map<PackageGroupOriginRestrictionType, Map<PackageGroupAllowedRepositoryUpdateType, List<String>>> allowedRepositoryUpdates() {
        return PackageGroupAllowedRepositoryUpdatesCopier.copyStringToEnum(this.allowedRepositoryUpdates);
    }

    public final boolean hasAllowedRepositoryUpdates() {
        return this.allowedRepositoryUpdates != null && !(this.allowedRepositoryUpdates instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, List<String>>> allowedRepositoryUpdatesAsStrings() {
        return this.allowedRepositoryUpdates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.packageGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedRepositoryUpdates() ? this.allowedRepositoryUpdatesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageGroupOriginConfigurationResponse)) {
            return false;
        }
        UpdatePackageGroupOriginConfigurationResponse other = (UpdatePackageGroupOriginConfigurationResponse)((Object)obj);
        return Objects.equals(this.packageGroup(), other.packageGroup()) && this.hasAllowedRepositoryUpdates() == other.hasAllowedRepositoryUpdates() && Objects.equals(this.allowedRepositoryUpdatesAsStrings(), other.allowedRepositoryUpdatesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePackageGroupOriginConfigurationResponse").add("PackageGroup", (Object)this.packageGroup()).add("AllowedRepositoryUpdates", this.hasAllowedRepositoryUpdates() ? this.allowedRepositoryUpdatesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packageGroup": {
                return Optional.ofNullable(clazz.cast(this.packageGroup()));
            }
            case "allowedRepositoryUpdates": {
                return Optional.ofNullable(clazz.cast(this.allowedRepositoryUpdatesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackageGroupOriginConfigurationResponse, T> g) {
        return obj -> g.apply((UpdatePackageGroupOriginConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactResponse.BuilderImpl
    implements Builder {
        private PackageGroupDescription packageGroup;
        private Map<String, Map<String, List<String>>> allowedRepositoryUpdates = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackageGroupOriginConfigurationResponse model) {
            super(model);
            this.packageGroup(model.packageGroup);
            this.allowedRepositoryUpdatesWithStrings(model.allowedRepositoryUpdates);
        }

        public final PackageGroupDescription.Builder getPackageGroup() {
            return this.packageGroup != null ? this.packageGroup.toBuilder() : null;
        }

        public final void setPackageGroup(PackageGroupDescription.BuilderImpl packageGroup) {
            this.packageGroup = packageGroup != null ? packageGroup.build() : null;
        }

        @Override
        public final Builder packageGroup(PackageGroupDescription packageGroup) {
            this.packageGroup = packageGroup;
            return this;
        }

        public final Map<String, ? extends Map<String, ? extends Collection<String>>> getAllowedRepositoryUpdates() {
            if (this.allowedRepositoryUpdates instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.allowedRepositoryUpdates;
        }

        public final void setAllowedRepositoryUpdates(Map<String, ? extends Map<String, ? extends Collection<String>>> allowedRepositoryUpdates) {
            this.allowedRepositoryUpdates = PackageGroupAllowedRepositoryUpdatesCopier.copy(allowedRepositoryUpdates);
        }

        @Override
        public final Builder allowedRepositoryUpdatesWithStrings(Map<String, ? extends Map<String, ? extends Collection<String>>> allowedRepositoryUpdates) {
            this.allowedRepositoryUpdates = PackageGroupAllowedRepositoryUpdatesCopier.copy(allowedRepositoryUpdates);
            return this;
        }

        @Override
        public final Builder allowedRepositoryUpdates(Map<PackageGroupOriginRestrictionType, ? extends Map<PackageGroupAllowedRepositoryUpdateType, ? extends Collection<String>>> allowedRepositoryUpdates) {
            this.allowedRepositoryUpdates = PackageGroupAllowedRepositoryUpdatesCopier.copyEnumToString(allowedRepositoryUpdates);
            return this;
        }

        @Override
        public UpdatePackageGroupOriginConfigurationResponse build() {
            return new UpdatePackageGroupOriginConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeartifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePackageGroupOriginConfigurationResponse> {
        public Builder packageGroup(PackageGroupDescription var1);

        default public Builder packageGroup(Consumer<PackageGroupDescription.Builder> packageGroup) {
            return this.packageGroup((PackageGroupDescription)((PackageGroupDescription.Builder)PackageGroupDescription.builder().applyMutation(packageGroup)).build());
        }

        public Builder allowedRepositoryUpdatesWithStrings(Map<String, ? extends Map<String, ? extends Collection<String>>> var1);

        public Builder allowedRepositoryUpdates(Map<PackageGroupOriginRestrictionType, ? extends Map<PackageGroupAllowedRepositoryUpdateType, ? extends Collection<String>>> var1);
    }
}

