/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateExternalConnectionRequest
extends CodeartifactRequest
implements ToCopyableBuilder<Builder, AssociateExternalConnectionRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(AssociateExternalConnectionRequest.getter(AssociateExternalConnectionRequest::domain)).setter(AssociateExternalConnectionRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()}).build();
    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainOwner").getter(AssociateExternalConnectionRequest.getter(AssociateExternalConnectionRequest::domainOwner)).setter(AssociateExternalConnectionRequest.setter(Builder::domainOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()}).build();
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repository").getter(AssociateExternalConnectionRequest.getter(AssociateExternalConnectionRequest::repository)).setter(AssociateExternalConnectionRequest.setter(Builder::repository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("repository").build()}).build();
    private static final SdkField<String> EXTERNAL_CONNECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalConnection").getter(AssociateExternalConnectionRequest.getter(AssociateExternalConnectionRequest::externalConnection)).setter(AssociateExternalConnectionRequest.setter(Builder::externalConnection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("external-connection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, DOMAIN_OWNER_FIELD, REPOSITORY_FIELD, EXTERNAL_CONNECTION_FIELD));
    private final String domain;
    private final String domainOwner;
    private final String repository;
    private final String externalConnection;

    private AssociateExternalConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.repository = builder.repository;
        this.externalConnection = builder.externalConnection;
    }

    public final String domain() {
        return this.domain;
    }

    public final String domainOwner() {
        return this.domainOwner;
    }

    public final String repository() {
        return this.repository;
    }

    public final String externalConnection() {
        return this.externalConnection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalConnection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateExternalConnectionRequest)) {
            return false;
        }
        AssociateExternalConnectionRequest other = (AssociateExternalConnectionRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainOwner(), other.domainOwner()) && Objects.equals(this.repository(), other.repository()) && Objects.equals(this.externalConnection(), other.externalConnection());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateExternalConnectionRequest").add("Domain", (Object)this.domain()).add("DomainOwner", (Object)this.domainOwner()).add("Repository", (Object)this.repository()).add("ExternalConnection", (Object)this.externalConnection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "domainOwner": {
                return Optional.ofNullable(clazz.cast(this.domainOwner()));
            }
            case "repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
            case "externalConnection": {
                return Optional.ofNullable(clazz.cast(this.externalConnection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateExternalConnectionRequest, T> g) {
        return obj -> g.apply((AssociateExternalConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactRequest.BuilderImpl
    implements Builder {
        private String domain;
        private String domainOwner;
        private String repository;
        private String externalConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateExternalConnectionRequest model) {
            super(model);
            this.domain(model.domain);
            this.domainOwner(model.domainOwner);
            this.repository(model.repository);
            this.externalConnection(model.externalConnection);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainOwner() {
            return this.domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final String getRepository() {
            return this.repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getExternalConnection() {
            return this.externalConnection;
        }

        public final void setExternalConnection(String externalConnection) {
            this.externalConnection = externalConnection;
        }

        @Override
        public final Builder externalConnection(String externalConnection) {
            this.externalConnection = externalConnection;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateExternalConnectionRequest build() {
            return new AssociateExternalConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeartifactRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateExternalConnectionRequest> {
        public Builder domain(String var1);

        public Builder domainOwner(String var1);

        public Builder repository(String var1);

        public Builder externalConnection(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

