/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactAsyncClient;
import software.amazon.awssdk.services.codeartifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeartifact.model.ListPackageGroupsRequest;
import software.amazon.awssdk.services.codeartifact.model.ListPackageGroupsResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupSummary;

public class ListPackageGroupsPublisher
implements SdkPublisher<ListPackageGroupsResponse> {
    private final CodeartifactAsyncClient client;
    private final ListPackageGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPackageGroupsPublisher(CodeartifactAsyncClient client, ListPackageGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPackageGroupsPublisher(CodeartifactAsyncClient client, ListPackageGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPackageGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPackageGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PackageGroupSummary> packageGroups() {
        Function<ListPackageGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.packageGroups() != null) {
                return response.packageGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPackageGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPackageGroupsResponseFetcher
    implements AsyncPageFetcher<ListPackageGroupsResponse> {
        private ListPackageGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListPackageGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPackageGroupsResponse> nextPage(ListPackageGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListPackageGroupsPublisher.this.client.listPackageGroups(ListPackageGroupsPublisher.this.firstRequest);
            }
            return ListPackageGroupsPublisher.this.client.listPackageGroups((ListPackageGroupsRequest)((Object)ListPackageGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

