/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.PackageFormat;
import software.amazon.awssdk.services.codeartifact.model.PackageOriginConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageDescription> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(PackageDescription.getter(PackageDescription::formatAsString)).setter(PackageDescription.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(PackageDescription.getter(PackageDescription::namespace)).setter(PackageDescription.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PackageDescription.getter(PackageDescription::name)).setter(PackageDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<PackageOriginConfiguration> ORIGIN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("originConfiguration").getter(PackageDescription.getter(PackageDescription::originConfiguration)).setter(PackageDescription.setter(Builder::originConfiguration)).constructor(PackageOriginConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, NAMESPACE_FIELD, NAME_FIELD, ORIGIN_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String format;
    private final String namespace;
    private final String name;
    private final PackageOriginConfiguration originConfiguration;

    private PackageDescription(BuilderImpl builder) {
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.originConfiguration = builder.originConfiguration;
    }

    public final PackageFormat format() {
        return PackageFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String name() {
        return this.name;
    }

    public final PackageOriginConfiguration originConfiguration() {
        return this.originConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.originConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageDescription)) {
            return false;
        }
        PackageDescription other = (PackageDescription)obj;
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.originConfiguration(), other.originConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"PackageDescription").add("Format", (Object)this.formatAsString()).add("Namespace", (Object)this.namespace()).add("Name", (Object)this.name()).add("OriginConfiguration", (Object)this.originConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "originConfiguration": {
                return Optional.ofNullable(clazz.cast(this.originConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageDescription, T> g) {
        return obj -> g.apply((PackageDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private String namespace;
        private String name;
        private PackageOriginConfiguration originConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageDescription model) {
            this.format(model.format);
            this.namespace(model.namespace);
            this.name(model.name);
            this.originConfiguration(model.originConfiguration);
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PackageOriginConfiguration.Builder getOriginConfiguration() {
            return this.originConfiguration != null ? this.originConfiguration.toBuilder() : null;
        }

        public final void setOriginConfiguration(PackageOriginConfiguration.BuilderImpl originConfiguration) {
            this.originConfiguration = originConfiguration != null ? originConfiguration.build() : null;
        }

        @Override
        public final Builder originConfiguration(PackageOriginConfiguration originConfiguration) {
            this.originConfiguration = originConfiguration;
            return this;
        }

        public PackageDescription build() {
            return new PackageDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageDescription> {
        public Builder format(String var1);

        public Builder format(PackageFormat var1);

        public Builder namespace(String var1);

        public Builder name(String var1);

        public Builder originConfiguration(PackageOriginConfiguration var1);

        default public Builder originConfiguration(Consumer<PackageOriginConfiguration.Builder> originConfiguration) {
            return this.originConfiguration((PackageOriginConfiguration)((PackageOriginConfiguration.Builder)PackageOriginConfiguration.builder().applyMutation(originConfiguration)).build());
        }
    }
}

