/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PackageVersionErrorCode {
    ALREADY_EXISTS("ALREADY_EXISTS"),
    MISMATCHED_REVISION("MISMATCHED_REVISION"),
    MISMATCHED_STATUS("MISMATCHED_STATUS"),
    NOT_ALLOWED("NOT_ALLOWED"),
    NOT_FOUND("NOT_FOUND"),
    SKIPPED("SKIPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PackageVersionErrorCode> VALUE_MAP;
    private final String value;

    private PackageVersionErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PackageVersionErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PackageVersionErrorCode> knownValues() {
        EnumSet<PackageVersionErrorCode> knownValues = EnumSet.allOf(PackageVersionErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PackageVersionErrorCode.class, PackageVersionErrorCode::toString);
    }
}

