/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRepositoriesInDomainRequest
extends CodeartifactRequest
implements ToCopyableBuilder<Builder, ListRepositoriesInDomainRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(ListRepositoriesInDomainRequest.getter(ListRepositoriesInDomainRequest::domain)).setter(ListRepositoriesInDomainRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()}).build();
    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainOwner").getter(ListRepositoriesInDomainRequest.getter(ListRepositoriesInDomainRequest::domainOwner)).setter(ListRepositoriesInDomainRequest.setter(Builder::domainOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()}).build();
    private static final SdkField<String> ADMINISTRATOR_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("administratorAccount").getter(ListRepositoriesInDomainRequest.getter(ListRepositoriesInDomainRequest::administratorAccount)).setter(ListRepositoriesInDomainRequest.setter(Builder::administratorAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("administrator-account").build()}).build();
    private static final SdkField<String> REPOSITORY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryPrefix").getter(ListRepositoriesInDomainRequest.getter(ListRepositoriesInDomainRequest::repositoryPrefix)).setter(ListRepositoriesInDomainRequest.setter(Builder::repositoryPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("repository-prefix").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListRepositoriesInDomainRequest.getter(ListRepositoriesInDomainRequest::maxResults)).setter(ListRepositoriesInDomainRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRepositoriesInDomainRequest.getter(ListRepositoriesInDomainRequest::nextToken)).setter(ListRepositoriesInDomainRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, DOMAIN_OWNER_FIELD, ADMINISTRATOR_ACCOUNT_FIELD, REPOSITORY_PREFIX_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String domain;
    private final String domainOwner;
    private final String administratorAccount;
    private final String repositoryPrefix;
    private final Integer maxResults;
    private final String nextToken;

    private ListRepositoriesInDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.administratorAccount = builder.administratorAccount;
        this.repositoryPrefix = builder.repositoryPrefix;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String domain() {
        return this.domain;
    }

    public final String domainOwner() {
        return this.domainOwner;
    }

    public final String administratorAccount() {
        return this.administratorAccount;
    }

    public final String repositoryPrefix() {
        return this.repositoryPrefix;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.administratorAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositoriesInDomainRequest)) {
            return false;
        }
        ListRepositoriesInDomainRequest other = (ListRepositoriesInDomainRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainOwner(), other.domainOwner()) && Objects.equals(this.administratorAccount(), other.administratorAccount()) && Objects.equals(this.repositoryPrefix(), other.repositoryPrefix()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRepositoriesInDomainRequest").add("Domain", (Object)this.domain()).add("DomainOwner", (Object)this.domainOwner()).add("AdministratorAccount", (Object)this.administratorAccount()).add("RepositoryPrefix", (Object)this.repositoryPrefix()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "domainOwner": {
                return Optional.ofNullable(clazz.cast(this.domainOwner()));
            }
            case "administratorAccount": {
                return Optional.ofNullable(clazz.cast(this.administratorAccount()));
            }
            case "repositoryPrefix": {
                return Optional.ofNullable(clazz.cast(this.repositoryPrefix()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRepositoriesInDomainRequest, T> g) {
        return obj -> g.apply((ListRepositoriesInDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactRequest.BuilderImpl
    implements Builder {
        private String domain;
        private String domainOwner;
        private String administratorAccount;
        private String repositoryPrefix;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositoriesInDomainRequest model) {
            super(model);
            this.domain(model.domain);
            this.domainOwner(model.domainOwner);
            this.administratorAccount(model.administratorAccount);
            this.repositoryPrefix(model.repositoryPrefix);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDomainOwner() {
            return this.domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        public final String getAdministratorAccount() {
            return this.administratorAccount;
        }

        @Override
        public final Builder administratorAccount(String administratorAccount) {
            this.administratorAccount = administratorAccount;
            return this;
        }

        public final void setAdministratorAccount(String administratorAccount) {
            this.administratorAccount = administratorAccount;
        }

        public final String getRepositoryPrefix() {
            return this.repositoryPrefix;
        }

        @Override
        public final Builder repositoryPrefix(String repositoryPrefix) {
            this.repositoryPrefix = repositoryPrefix;
            return this;
        }

        public final void setRepositoryPrefix(String repositoryPrefix) {
            this.repositoryPrefix = repositoryPrefix;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRepositoriesInDomainRequest build() {
            return new ListRepositoriesInDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeartifactRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRepositoriesInDomainRequest> {
        public Builder domain(String var1);

        public Builder domainOwner(String var1);

        public Builder administratorAccount(String var1);

        public Builder repositoryPrefix(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

