/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codeartifact.model.AssetHashesCopier;
import software.amazon.awssdk.services.codeartifact.model.HashAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AssetSummary.getter(AssetSummary::name)).setter(AssetSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Long> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("size").getter(AssetSummary.getter(AssetSummary::size)).setter(AssetSummary.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()}).build();
    private static final SdkField<Map<String, String>> HASHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("hashes").getter(AssetSummary.getter(AssetSummary::hashesAsStrings)).setter(AssetSummary.setter(Builder::hashesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hashes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SIZE_FIELD, HASHES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Long size;
    private final Map<String, String> hashes;

    private AssetSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.size = builder.size;
        this.hashes = builder.hashes;
    }

    public String name() {
        return this.name;
    }

    public Long size() {
        return this.size;
    }

    public Map<HashAlgorithm, String> hashes() {
        return AssetHashesCopier.copyStringToEnum(this.hashes);
    }

    public boolean hasHashes() {
        return this.hashes != null && !(this.hashes instanceof SdkAutoConstructMap);
    }

    public Map<String, String> hashesAsStrings() {
        return this.hashes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHashes() ? this.hashesAsStrings() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetSummary)) {
            return false;
        }
        AssetSummary other = (AssetSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.size(), other.size()) && this.hasHashes() == other.hasHashes() && Objects.equals(this.hashesAsStrings(), other.hashesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"AssetSummary").add("Name", (Object)this.name()).add("Size", (Object)this.size()).add("Hashes", this.hasHashes() ? this.hashesAsStrings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "hashes": {
                return Optional.ofNullable(clazz.cast(this.hashesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetSummary, T> g) {
        return obj -> g.apply((AssetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Long size;
        private Map<String, String> hashes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetSummary model) {
            this.name(model.name);
            this.size(model.size);
            this.hashesWithStrings(model.hashes);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public final Map<String, String> getHashes() {
            if (this.hashes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.hashes;
        }

        @Override
        public final Builder hashesWithStrings(Map<String, String> hashes) {
            this.hashes = AssetHashesCopier.copy(hashes);
            return this;
        }

        @Override
        public final Builder hashes(Map<HashAlgorithm, String> hashes) {
            this.hashes = AssetHashesCopier.copyEnumToString(hashes);
            return this;
        }

        public final void setHashes(Map<String, String> hashes) {
            this.hashes = AssetHashesCopier.copy(hashes);
        }

        public AssetSummary build() {
            return new AssetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetSummary> {
        public Builder name(String var1);

        public Builder size(Long var1);

        public Builder hashesWithStrings(Map<String, String> var1);

        public Builder hashes(Map<HashAlgorithm, String> var1);
    }
}

