/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAuthorizationTokenResponse
extends CodeartifactResponse
implements ToCopyableBuilder<Builder, GetAuthorizationTokenResponse> {
    private static final SdkField<String> AUTHORIZATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizationToken").getter(GetAuthorizationTokenResponse.getter(GetAuthorizationTokenResponse::authorizationToken)).setter(GetAuthorizationTokenResponse.setter(Builder::authorizationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationToken").build()}).build();
    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiration").getter(GetAuthorizationTokenResponse.getter(GetAuthorizationTokenResponse::expiration)).setter(GetAuthorizationTokenResponse.setter(Builder::expiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_TOKEN_FIELD, EXPIRATION_FIELD));
    private final String authorizationToken;
    private final Instant expiration;

    private GetAuthorizationTokenResponse(BuilderImpl builder) {
        super(builder);
        this.authorizationToken = builder.authorizationToken;
        this.expiration = builder.expiration;
    }

    public String authorizationToken() {
        return this.authorizationToken;
    }

    public Instant expiration() {
        return this.expiration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAuthorizationTokenResponse)) {
            return false;
        }
        GetAuthorizationTokenResponse other = (GetAuthorizationTokenResponse)((Object)obj);
        return Objects.equals(this.authorizationToken(), other.authorizationToken()) && Objects.equals(this.expiration(), other.expiration());
    }

    public String toString() {
        return ToString.builder((String)"GetAuthorizationTokenResponse").add("AuthorizationToken", (Object)this.authorizationToken()).add("Expiration", (Object)this.expiration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizationToken": {
                return Optional.ofNullable(clazz.cast(this.authorizationToken()));
            }
            case "expiration": {
                return Optional.ofNullable(clazz.cast(this.expiration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAuthorizationTokenResponse, T> g) {
        return obj -> g.apply((GetAuthorizationTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactResponse.BuilderImpl
    implements Builder {
        private String authorizationToken;
        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAuthorizationTokenResponse model) {
            super(model);
            this.authorizationToken(model.authorizationToken);
            this.expiration(model.expiration);
        }

        public final String getAuthorizationToken() {
            return this.authorizationToken;
        }

        @Override
        public final Builder authorizationToken(String authorizationToken) {
            this.authorizationToken = authorizationToken;
            return this;
        }

        public final void setAuthorizationToken(String authorizationToken) {
            this.authorizationToken = authorizationToken;
        }

        public final Instant getExpiration() {
            return this.expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public GetAuthorizationTokenResponse build() {
            return new GetAuthorizationTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeartifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAuthorizationTokenResponse> {
        public Builder authorizationToken(String var1);

        public Builder expiration(Instant var1);
    }
}

