/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLogRecordRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, GetLogRecordRequest> {
    private static final SdkField<String> LOG_RECORD_POINTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetLogRecordRequest.getter(GetLogRecordRequest::logRecordPointer)).setter(GetLogRecordRequest.setter(Builder::logRecordPointer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logRecordPointer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_RECORD_POINTER_FIELD));
    private final String logRecordPointer;

    private GetLogRecordRequest(BuilderImpl builder) {
        super(builder);
        this.logRecordPointer = builder.logRecordPointer;
    }

    public String logRecordPointer() {
        return this.logRecordPointer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logRecordPointer());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogRecordRequest)) {
            return false;
        }
        GetLogRecordRequest other = (GetLogRecordRequest)((Object)obj);
        return Objects.equals(this.logRecordPointer(), other.logRecordPointer());
    }

    public String toString() {
        return ToString.builder((String)"GetLogRecordRequest").add("LogRecordPointer", (Object)this.logRecordPointer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logRecordPointer": {
                return Optional.ofNullable(clazz.cast(this.logRecordPointer()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLogRecordRequest, T> g) {
        return obj -> g.apply((GetLogRecordRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String logRecordPointer;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogRecordRequest model) {
            super(model);
            this.logRecordPointer(model.logRecordPointer);
        }

        public final String getLogRecordPointer() {
            return this.logRecordPointer;
        }

        @Override
        public final Builder logRecordPointer(String logRecordPointer) {
            this.logRecordPointer = logRecordPointer;
            return this;
        }

        public final void setLogRecordPointer(String logRecordPointer) {
            this.logRecordPointer = logRecordPointer;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLogRecordRequest build() {
            return new GetLogRecordRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLogRecordRequest> {
        public Builder logRecordPointer(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

